package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.MessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.QuestionMessageItem;

/**
 * Created by mika on 2016. 12. 9..
 */
public class UserMessageHolder extends ChatMessageHolder {
  View headBubble, contextBubble, contentBubble;

  public UserMessageHolder(
      View itemView,
      MessageClickListener listener,
      ChatDataDictionary dictionary,
      int backColor,
      int textColor) {
    super(itemView, listener, dictionary);

    headBubble = itemView.findViewById(R.id.message_head_color);
    contextBubble = itemView.findViewById(R.id.message_context_color);
    contentBubble = itemView.findViewById(R.id.message_content);

    headBubble.setBackgroundColor(backColor);
    contextBubble.setBackgroundColor(backColor);
    contentBubble.setBackgroundColor(backColor);
    text.setTextColor(textColor);
  }
}
