package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.ChatDataDictionary;
import com.zoyi.channel.plugin.android.activity.chat.listener.MessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ActionMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

/**
 * Created by mika on 2016. 12. 9..
 */
public class ManagerMessageHolder extends ChatMessageHolder {
  Context context;
  AvatarLayout avatar;
  TextView textName;
  LinearLayout contentList;

  public ManagerMessageHolder(
      View itemView,
      MessageClickListener listener,
      ChatDataDictionary dictionary) {
    super(itemView, listener, dictionary);

    context = itemView.getContext();
    avatar = (AvatarLayout) itemView.findViewById(R.id.message_avatar);
    textName = (TextView) itemView.findViewById(R.id.message_name);
    contentList = (LinearLayout) itemView.findViewById(R.id.message_addon_content);
  }

  protected void setProfile(ProfileEntity profile) {
    avatar.set(profile);
    if (profile == null) {
      textName.setText(Utils.getString(context, "ch.unknown"));
    } else {
      textName.setText(profile.getName());
    }
  }

  public void set(ChatMessageItem item, boolean isContext) {
    super.set(item.getMessage(), isContext);
    contentList.setVisibility(View.GONE);
    setProfile(dictionary.getProfile(
        item.getMessage().getPersonType(),
        item.getMessage().getPersonId()));
  }
}
