package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import android.os.Looper;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;

/**
 * Created by mika on 2016. 4. 19..
 */
public class ChannelPlugin {
  static Application application;
  static String pluginId;
  static ChannelApi service;
  static ActivityLifecycleManager lifecycleManager;
  static Thread.UncaughtExceptionHandler mUncaughtExceptionHandler;

  static Plugin plugin;
  static boolean checkInProcess = false, checkedIn = false, mainRunning = false;

  public static void initialize(Application application, String pluginId) {
    if (ChannelPlugin.application == null && ChannelPlugin.pluginId == null) {
      if (application == null) {
        L.e("Application cannot be null");
        return;
      }
      if (pluginId == null) {
        L.e("Plugin key cannot be null");
        return;
      }
      ChannelPlugin.application = application;
      ChannelPlugin.pluginId = pluginId;

      ChannelPlugin.lifecycleManager = new ActivityLifecycleManager();
      ChannelPlugin.application.registerActivityLifecycleCallbacks(lifecycleManager);
      SocketManager.init();

      ChannelPlugin.mUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
      Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler() {
        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
          if (Looper.getMainLooper().getThread() == thread) {
            ChannelPlugin.mUncaughtExceptionHandler.uncaughtException(thread, ex);
          } else if (ex instanceof RejectedExecutionException) {
            SocketManager.reconnect();
          }
        }
      });

      ChannelStore.veilId = PrefSupervisor.getVeilId(application);
    }
  }

  public static void checkIn() {
    checkIn(null);
  }

  public static void checkIn(final CheckIn checkIn) {
    if (checkInProcess) {
      return;
    }
    if (application == null || pluginId == null) {
      L.e("Please initialize first");
      return;
    }

    checkOut();
    checkInProcess = true;

    getService().getLastestPackage("com.zoyi.channel.plugin.android", BuildConfig.VERSION_NAME)
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new RestSubscriber<PackageWrapper>() {
          @Override
          public void onError(Throwable error) {
            L.e(error.getMessage());
          }

          @Override
          public void onNext(PackageWrapper wrapper) {
            if (!wrapper.isNeedToUpgrade()) {
              init(checkIn);
            } else {
              L.e("Need to upgrade");
            }
          }
        });
  }

  private static void init(CheckIn checkIn) {
    Map<String, Object> form = new HashMap<>();
    if (checkIn != null) {
      form.put("name", checkIn.getName());
      form.put("mobileNumber", checkIn.getMobileNumber());
      form.put("avatarUrl", checkIn.getAvatarUrl());
      form.put("meta", checkIn.getMeta());
    }

    RequestBody body = RequestUtils.form(form).create();
    Map<String, String> headers = new HashMap<>();

    if (checkIn != null && checkIn.getUserId() != null) {
      headers.put("X-User-Id", checkIn.getUserId());
    }
    if (PrefSupervisor.getVeilId(application) != null) {
      headers.put("X-Veil-Id", PrefSupervisor.getVeilId(application));
    }

    getService().checkIn(headers, pluginId, body)
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new RestSubscriber<PluginWrapper>() {
          @Override
          public void onError(Throwable e) {
            L.e(e.getMessage());
            checkInProcess = false;
          }

          @Override
          public void onNext(PluginWrapper pluginWrapper) {
            PrefSupervisor.setVeilId(application, pluginWrapper.getVeilId());

            ChannelPlugin.plugin = pluginWrapper.getPlugin();

            if (pluginWrapper.getUser() != null) {
              ChannelStore.user = pluginWrapper.getUser();
            }
            ChannelStore.veil = pluginWrapper.getVeil();
            ChannelStore.veilId = pluginWrapper.getVeilId();
            ChannelStore.channel = pluginWrapper.getChannel();

            ChannelPlugin.checkedIn = true;
            ChannelPlugin.checkInProcess = false;

            SocketManager.setChannelId(pluginWrapper.getChannel().getId());
            SocketManager.connect();

            RxBus.post(new CommandBus(Command.CHECKED_IN, pluginWrapper.getPlugin()));

            ChannelStore.startFetchPlugin();
            ChannelStore.fetchScripts();
          }
        });
  }

  public static void checkOut() {
    checkedIn = false;

    ChannelStore.stopFetchPlugin();
    RxBus.post(new CommandBus(Command.CHECKED_OUT));
    
    SocketManager.setChannelId(null);
    SocketManager.disconnect();

    ChannelStore.user = null;
  }

  public static void launch(Context context) {
    if (!checkedIn) {
      L.e("Please ch_plugin_check in first");
      return;
    }
    if (context != null) {
      IntentUtils.setNextActivity(context, UserChatListActivity.class).startActivity();
    }
  }

  public static Application getApplication() {
    return application;
  }

  public static ChannelApi getService() {
    if (service == null) {
      service = ServiceFactory.create();
    }
    return service;
  }

  public static Plugin getPlugin() {
    if (checkedIn && plugin != null) {
      return plugin;
    }
    return null;
  }

  public static String getPluginId() {
    return pluginId;
  }

  public static boolean isMainRunning() {
    return mainRunning;
  }

  static void setMainRunning(boolean mainRunning) {
    ChannelPlugin.mainRunning = mainRunning;
  }
}
