/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.zoyi.channel.plugin.android.R;

public class CircleProgressBar
extends View {
    private float strokeWidth = 4.0f;
    private float progress = 0.0f;
    private int min = 0;
    private int max = 100;
    private int startAngle = -90;
    private int color = 0;
    private RectF rectF;
    private Paint backgroundPaint;
    private Paint foregroundPaint;

    public CircleProgressBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.rectF = new RectF();
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircleProgressBar, 0, 0);
        try {
            this.strokeWidth = typedArray.getDimension(R.styleable.CircleProgressBar_progressBarThickness, this.strokeWidth);
            this.progress = typedArray.getFloat(R.styleable.CircleProgressBar_progress, this.progress);
            this.color = typedArray.getInt(R.styleable.CircleProgressBar_progressbarColor, this.color);
            this.min = typedArray.getInt(R.styleable.CircleProgressBar_min, this.min);
            this.max = typedArray.getInt(R.styleable.CircleProgressBar_max, this.max);
        }
        finally {
            typedArray.recycle();
        }
        this.backgroundPaint = new Paint(1);
        this.backgroundPaint.setColor(this.adjustAlpha(this.color, 0.3f));
        this.backgroundPaint.setStyle(Paint.Style.STROKE);
        this.backgroundPaint.setStrokeWidth(this.strokeWidth);
        this.foregroundPaint = new Paint(1);
        this.foregroundPaint.setColor(this.color);
        this.foregroundPaint.setStyle(Paint.Style.STROKE);
        this.foregroundPaint.setStrokeWidth(this.strokeWidth);
    }

    private int adjustAlpha(int color2, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color2) * factor);
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = CircleProgressBar.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int width = CircleProgressBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int min = Math.min(width, height);
        this.setMeasuredDimension(min, min);
        this.rectF.set(0.0f + this.strokeWidth / 2.0f, 0.0f + this.strokeWidth / 2.0f, (float)min - this.strokeWidth / 2.0f, (float)min - this.strokeWidth / 2.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float angle = 360.0f * this.progress / (float)this.max;
        canvas.drawArc(this.rectF, (float)this.startAngle, angle, false, this.foregroundPaint);
    }

    public void setProgress(float progress) {
        this.progress = progress;
        this.invalidate();
    }
}

