/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.JsonDeserializationContext;
import com.zoyi.com.google.gson.JsonDeserializer;
import com.zoyi.com.google.gson.JsonElement;
import com.zoyi.com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class MessageDeserializer
implements JsonDeserializer<Message> {
    private Gson gson = new Gson();

    public Message deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Message message = (Message)this.gson.fromJson(json, typeOfT);
        if (message != null) {
            String newId;
            if (message.getFile() != null && message.getFile().isImage() && message.getFile().getPreviewThumb() != null) {
                newId = String.format("%s:%s", File.class.getSimpleName(), message.getFile().getId());
                message.getFile().getPreviewThumb().setId(newId);
            }
            if (message.getWebPage() != null && message.getWebPage().getPreviewThumb() != null) {
                newId = String.format("%s:%s", WebPage.class.getSimpleName(), message.getWebPage().getId());
                message.getWebPage().getPreviewThumb().setId(newId);
            }
        }
        return message;
    }
}

