/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.download;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.MimeTypeMap;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.util.DownloadUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import com.zoyi.channel.plugin.android.view.layout.CircleProgressBar;
import com.zoyi.retrofit2.okhttp3.Call;
import java.io.File;

public class DownloadActivity
extends BaseActivity {
    CircleProgressBar progress;
    View imageDone;
    FrameLayout imageCancel;
    String url;
    String filename;
    boolean image;
    Call call;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init(R.layout.ch_plugin_activity_download);
        this.progress = (CircleProgressBar)this.findViewById(R.id.download_progress);
        this.imageDone = this.findViewById(R.id.image_done);
        this.imageCancel = (FrameLayout)this.findViewById(R.id.layout_cancel);
        this.imageCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                L.i("Cancel download");
                try {
                    if (DownloadActivity.this.call != null && !DownloadActivity.this.call.isCanceled()) {
                        DownloadActivity.this.call.cancel();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Channel channel = ChannelStore.getChannel();
        if (channel != null) {
            this.setStatusBarColor(channel.getBackgroundColor());
        } else {
            this.setStatusBarColor(-16777216);
        }
        try {
            this.url = this.getIntent().getStringExtra("url");
            this.filename = this.getIntent().getStringExtra("filename");
            this.image = this.getIntent().getBooleanExtra("image", false);
        }
        finally {
            if (this.url == null || this.filename == null) {
                this.finish(2);
            }
        }
        this.download();
    }

    public void onBackPressed() {
    }

    protected void onPause() {
        super.onPause();
        this.overridePendingTransition(0, 0);
    }

    private void finish(int resultCode) {
        this.setResult(resultCode);
        this.finish();
    }

    @Override
    protected void permissionAccepted(int requestCode) {
        if (requestCode == 2) {
            this.download();
        } else {
            this.finish(2);
        }
    }

    private void download() {
        if (this.checkPermission(2)) {
            this.imageCancel.setVisibility(0);
            this.progress.setVisibility(0);
            this.call = DownloadUtils.downloadFile((Activity)this, this.url, this.filename, this.image, new DownloadUtils.ProgressListener(){

                @Override
                public void update(int progress) {
                    DownloadActivity.this.progressDownload(progress);
                }

                @Override
                public void error(Call call, String message) {
                    L.e(message);
                    if (call == null || !call.isCanceled()) {
                        DownloadActivity.this.finish(2);
                    } else {
                        DownloadActivity.this.finish(1);
                    }
                }

                @Override
                public void done(String savePath) {
                    DownloadActivity.this.finishDownload(savePath);
                }
            });
            if (this.call == null) {
                this.finish(2);
            }
        }
    }

    private void progressDownload(int progress) {
        this.progress.setProgress(progress);
    }

    private void finishDownload(String savePath) {
        File file;
        this.imageDone.setVisibility(0);
        this.imageCancel.setVisibility(8);
        this.progress.setVisibility(8);
        L.i(savePath + " " + this.image);
        if (!this.image && (file = new File(savePath)).exists()) {
            MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
            String ext = FilenameUtils.getExtension(savePath).toLowerCase();
            String type = mimeTypeMap.getMimeTypeFromExtension(ext);
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setDataAndType(Uri.fromFile((File)file), type);
                this.startActivity(intent);
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }
        Animation animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.ch_plugin_dialog_in);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                DownloadActivity.this.finish(0);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.imageDone.startAnimation(animation);
    }
}

