package com.zoyi.channel.plugin.android.wrapper;

import android.app.Activity;
import android.app.Application;

import com.splunk.mint.Mint;

public class BugTrace {

  private static final String SPLUNK_MINT_KEY = "22464da6";

  public static void init(Activity activity, boolean disableNetworkMonitor) {
    init(activity.getApplication(), disableNetworkMonitor);
  }

  public static void init(Activity activity) {
    init(activity.getApplication(), true);
  }

  public static void init(Application app, boolean disableNetworkMonitor) {
    if (disableNetworkMonitor) {
      Mint.disableNetworkMonitoring();
    }
    Mint.initAndStartSession(app, SPLUNK_MINT_KEY);
  }

  public static void release(Activity activity) {
    release(activity.getApplication());
  }

  public static void release(Application app) {
    Mint.flush();
    Mint.closeSession(app);
  }
}
