package com.zoyi.channel.plugin.android.network;

import com.zoyi.com.google.gson.Gson;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.retrofit2.Retrofit;
import com.zoyi.retrofit2.converter.gson.GsonConverterFactory;
import com.zoyi.retrofit2.okhttp3.OkHttpClient;
import com.zoyi.retrofit2.okhttp3.logging.HttpLoggingInterceptor;

/**
 * Created by mika on 2016. 1. 20..
 */
public class ServiceFactory {
  public static ChannelApi create() {
//    String ENDPOINT = "https://api.dev.channel.io/";
    String ENDPOINT = "https://api.channel.io/";
//    String ENDPOINT = "http://10.0.0.65:8080/";

//    final RestAdapter restAdapter = new RestAdapter.Builder()
//      .setEndpoint(ENDPOINT)
//      .setConverter(new JacksonConverter())
//      .setRequestInterceptor(new RetrofitInterceptor())
//      .setErrorHandler(new ErrorConverter())
//      .setLogLevel(RestAdapter.LogLevel.FULL)
//      .setLog(new AndroidLog("Retrofit"))
//      .build();
//
//    return restAdapter.create(ChannelApi.class);

    HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor()
        .setLevel(L.DEBUG ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
    OkHttpClient client = new OkHttpClient.Builder()
        .addInterceptor(new RetrofitInterceptor())
        .addInterceptor(interceptor)
        .build();

    return new Retrofit.Builder()
        .baseUrl(ENDPOINT)
        .client(client)
        .addCallAdapterFactory(RxAdapterFactory.create())
        .addConverterFactory(GsonConverterFactory.create(new Gson()))
        .build()
        .create(ChannelApi.class);
  }
}
