package com.zoyi.channel.plugin.android.global;

import android.app.Application;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

/**
 * Created by mika on 2017. 1. 16..
 */
public class PrefSupervisor {
  private static final String VEIL_ID = "X-Veil-Id";

  private static SharedPreferences getPreferences(Application application) {
    return PreferenceManager.getDefaultSharedPreferences(application);
  }

  public static String getVeilId(Application application) {
    if (application != null) {
      return getPreferences(application).getString(VEIL_ID, null);
    }
    return null;
  }

  public static void setVeilId(Application application, String veilId) {
    SharedPreferences.Editor editor = getPreferences(application).edit();
    editor.putString(VEIL_ID, veilId);
    editor.apply();
  }
}
