package com.zoyi.channel.plugin.android.activity.userchat_list;

import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.MenuPosition;
import com.zoyi.channel.plugin.android.enumerate.MenuState;
import com.zoyi.channel.plugin.android.event.ChatCounterBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.handler.InfiniteListener;
import com.zoyi.channel.plugin.android.view.layout.ProfileLayout;
import com.zoyi.channel.plugin.android.wrapper.BugTrace;

/**
 * Created by mika on 2016. 12. 5..
 */
public class UserChatListActivity
    extends BaseActivity
    implements UserChatListActionListener, UserChatClickListener {
  private RelativeLayout profileLayout;
  private RecyclerView recyclerView;
  private FloatingActionButton fab;
  private LinearLayout profileList;

  private String tempChatId, chatId;

  private UserChatCounter userChatCounter;
  private UserChatListAction action;
  private UserChatListAdapter adapter;

  private boolean init = false;
  private boolean profileVisible = false;
  private UserChatListState state = UserChatListState.WAITING_SOCKET;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_user_chat_list);

    ((TextView) findViewById(R.id.text_powered)).setText(Html.fromHtml(getString(R.string.ch_plugin_powered_label)));

    profileLayout = (RelativeLayout) findViewById(R.id.layout_profile);
    profileList = (LinearLayout) findViewById(R.id.layout_profile_list);
    fab = (FloatingActionButton) findViewById(R.id.fab);
    fab.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        IntentUtils.setNextActivity(UserChatListActivity.this, ChatActivity.class)
            .putExtra("chatCount", userChatCounter.getCounter(chatId))
            .startActivity();
      }
    });
    fab.hide(false);
    profileLayout.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        setProfileLayout(false);
      }
    });
    findViewById(R.id.button_agreement).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        String url = "http://channel.io/ko/terms_user?channel="
            + (ChannelStore.getChannel() != null ? ChannelStore.getChannel().getName() : "");
        IntentUtils.setUrl(UserChatListActivity.this, url).startActivity();
      }
    });

    getBigBar().withActivity(this)
        .addMenu(ActionType.EXIT, MenuPosition.LEFT)
        .addMenu(ActionType.REFRESH, MenuPosition.RIGHT, MenuState.HIDDEN)
        .addMenu(ActionType.MORE, MenuPosition.RIGHT, MenuState.HIDDEN)
        .build();

    action = new UserChatListAction(this);
    adapter = new UserChatListAdapter(this);
    userChatCounter = new UserChatCounter();

    if (getIntent() != null) {
      tempChatId = getIntent().getStringExtra("chatId");
    }

    LinearLayoutManager manager = new LinearLayoutManager(this);
    recyclerView = (RecyclerView) findViewById(R.id.recycler_view);
    recyclerView.setLayoutManager(manager);
    recyclerView.setAdapter(adapter);
    recyclerView.setItemAnimator(null);
    recyclerView.getRecycledViewPool().setMaxRecycledViews(0, 40);
    recyclerView.addOnScrollListener(new InfiniteListener(manager, InfiniteListener.BOTTOM) {
      @Override
      public void refresh() {
        // not yet.
      }
    });

    setProfile();
    setStyle();

    BugTrace.init(this);
  }

  @Override
  protected void onDestroy() {
    BugTrace.release(this);
    super.onDestroy();
  }

  @Override
  protected void onStart() {
    chatId = null;
    super.onStart();
  }

  private void setProfile() {
    boolean flag = false;

    if (ChannelStore.getUserName() != null) {
      flag = true;
      ProfileLayout profile = new ProfileLayout(this);
      profile.set(
          Utils.getString(this, "ch.user_profile.user_name"),
          ChannelStore.getUserName());
      profileList.addView(profile);
    }
    if (ChannelStore.getMobileNumber() != null) {
      flag = true;
      ProfileLayout profile = new ProfileLayout(this);
      profile.set(
          Utils.getString(this, "ch.user_profile.mobile_number"),
          ChannelStore.getMobileNumber());
      profileList.addView(profile);
    }

    if (!flag) {
      ProfileLayout profile = new ProfileLayout(this);
      profile.set(Utils.getString(this, "ch.user_profile.empty"), "");
      profileList.addView(profile);
    }
  }

  @Override
  public void onBackPressed() {
    if (profileVisible) {
      setProfileLayout(false);
    } else {
      super.onBackPressed();
    }
  }

  private void setStyle() {
    Channel channel = ChannelStore.getChannel();
    if (channel == null) {
      finish();
    } else {
      setStatusBarColor(channel.getBackgroundColor());
      getBigBar().setTheme(channel.getBackgroundColor(), channel.getTextColor());
      getBigBar().setTitle(channel.getName());

      fab.setColorNormal(channel.getBackgroundColor());
      fab.setColorPressed(Utils.addBlackMask(channel.getBackgroundColor()));
      fab.setColorRipple(Color.WHITE);
      fab.setImageResource(
          channel.getTextColor() == Color.BLACK
              ? R.drawable.ch_plugin_ic_add_black_24dp
              : R.drawable.ch_plugin_ic_add_white_24dp);

      fab.attachToRecyclerView(recyclerView);
      getUserChats();
    }
  }

  private void getUserChats() {
    Channel channel = ChannelStore.getChannel();
    if (channel != null) {
      if (SocketManager.isReady()) {
        if (!init) {
          showProgress(Utils.getString(this, "ch.loading_information"));
        }
        startProcess(UserChatListState.USER_CHAT_LIST_LOADING);
        action.fetchUserChats(channel.getId());
      } else {
        startProcess(UserChatListState.WAITING_SOCKET);
        SocketManager.reconnect();
      }
    }
  }

  @Override
  public void userChatsFetched(UserChatsWrapper userChatsWrapper) {
    hideProgress();

    if (userChatsWrapper == null) {
      stopProcess(UserChatListState.USER_CHAT_LIST_NOT_LOADED);
      // show error
    } else {
      startProcess(UserChatListState.READY);
      adapter.init(userChatsWrapper);
      userChatCounter.setList(userChatsWrapper.getSessions());
      RxBus.post(new ChatCounterBus(userChatCounter.getCounter(chatId)));

      init = true;
      getBigBar().setMenuState(ActionType.MORE, MenuState.VISIBLE);
      if (!profileVisible) {
        fab.show();
      }

      if (tempChatId != null) {
        startChat(tempChatId);
        tempChatId = null;
      } else if (adapter.getItemCount() == 0) {
        IntentUtils.setNextActivity(UserChatListActivity.this, ChatActivity.class)
            .startActivityForResult(Const.USER_CHATS_IS_EMPTY);
      }
    }
  }

  private void refresh() {
    switch (state) {
      case WAITING_SOCKET:
        SocketManager.reconnect();
        break;

      case USER_CHAT_LIST_NOT_LOADED:
        getUserChats();
        break;
    }
  }

  @Override
  public void receiveCommand(Command command, Object object) {
    switch (command) {
      case READY:
        if (UserChatListState.WAITING_SOCKET.equals(state)) {
          getUserChats();
        } else {
          refresh();
        }
        break;

      case JOINED:
        chatId = (String) object;
        break;

      case SOCKET_DISCONNECTED:
        stopProcess(UserChatListState.WAITING_SOCKET);
        if (adapter != null) {
          adapter.stopRefreshBySocket();
        }
        break;
    }
  }

  @Override
  public void receiveData(ChannelModel channelModel, boolean upsert) {
    adapter.receiveChannelModel(channelModel, upsert);
    if (channelModel instanceof Session) {
      Session session = (Session) channelModel;
      if (upsert) {
        userChatCounter.upsert(session);
      } else {
        userChatCounter.delete(session);
      }
      if (session.getId() != null && !CompareUtils.isSame(session.getChatId(), chatId)) {
        RxBus.post(new ChatCounterBus(userChatCounter.getCounter(chatId)));
      }
    }
  }

  @Override
  public void optionClicked(ActionType actionType) {
    super.optionClicked(actionType);
    switch (actionType) {
      case REFRESH:
        getBigBar().setMenuState(ActionType.REFRESH, MenuState.HIDDEN);
        refresh();
        break;

      case MORE:
        toggleProfile();
        break;
    }
  }

  private void toggleProfile() {
    setProfileLayout(!profileVisible);
  }

  private void setProfileLayout(boolean profileVisible) {
    this.profileVisible = profileVisible;
    if (profileVisible) {
      fab.hide();
      profileLayout.setVisibility(View.VISIBLE);
    } else {
      fab.show();
      profileLayout.setVisibility(View.GONE);
    }
  }

  @Override
  public void clicked(String chatId) {
    startChat(chatId);
  }

  private void startChat(String chatId) {
    this.chatId = chatId;
    IntentUtils.setNextActivity(this, ChatActivity.class)
        .putExtra("chatId", chatId)
        .putExtra("chatCount", userChatCounter.getCounter(chatId))
        .startActivity();
  }

  private void startProcess(UserChatListState state) {
    this.state = state;
    getBigBar().setMenuState(ActionType.REFRESH, MenuState.HIDDEN);
  }

  private void stopProcess(UserChatListState state) {
    this.state = state;
    getBigBar().setMenuState(ActionType.REFRESH, MenuState.VISIBLE);
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    if (resultCode == Const.CLOSE_USER_CHATS && init && adapter.getItemCount() == 0) {
      finish();
    }
  }
}
