package com.zoyi.channel.plugin.android.activity.photo_picker;


import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.camera.RxImagePicker;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.MenuPosition;
import com.zoyi.channel.plugin.android.enumerate.MenuState;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.wrapper.MarginBox;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.rx.functions.Action1;

import java.util.ArrayList;

/**
 * Created by mika on 8/31/16.
 */
public class PhotoPickerActivity extends BaseActivity implements PhotoProcessListener {
  RecyclerView recyclerView;
  LinearLayout emptyLayout;
  int photoMargin;

  private PhotoPickerAdapter adapter;
  private int columns;
  private boolean init;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_photo_picker);

    recyclerView = (RecyclerView) findViewById(R.id.recycler_view_photo_picker);
    emptyLayout = (LinearLayout) findViewById(R.id.no_album);
    photoMargin = (int) Utils.dpToPx(this, 2);

    getBigBar().withActivity(this)
//        .setTitle(App.getResString("photo.all_images"))
        .addMenu(ActionType.BACK, MenuPosition.LEFT)
        .addMenu(ActionType.CAMERA, MenuPosition.RIGHT)
        .addMenu(ActionType.DONE, MenuPosition.RIGHT, MenuState.DISABLED)
        .build();

//    List<PhotoItem> selectedItems = new ArrayList<>();

    adapter = new PhotoPickerAdapter(this, R.layout.ch_plugin_item_photo_picker, this);
    orientationBasedUI(getResources().getConfiguration().orientation);
    recyclerView.setAdapter(adapter);
    recyclerView.setItemAnimator(null);

    showLoading();
  }

  @Override
  public void onConfigurationChanged(Configuration newConfig) {
    super.onConfigurationChanged(newConfig);
    orientationBasedUI(newConfig.orientation);
  }

  @Override
  protected void onResume() {
    super.onResume();
    if (!init) {
      init = true;
      refreshData();
    }
  }

  @Override
  public void onBackPressed() {
    setResult(RESULT_CANCELED);
    super.onBackPressed();
  }

  private void orientationBasedUI(int orientation) {
    final WindowManager windowManager = (WindowManager) getApplicationContext()
        .getSystemService(Context.WINDOW_SERVICE);
    final DisplayMetrics metrics = new DisplayMetrics();
    windowManager.getDefaultDisplay().getMetrics(metrics);

    columns = orientation == Configuration.ORIENTATION_PORTRAIT ? 3 : 5;

    GridLayoutManager layoutManager = new GridLayoutManager(this, columns);
    recyclerView.setLayoutManager(layoutManager);
    recyclerView.setAdapter(adapter);

    if (adapter != null) {
      int size = metrics.widthPixels / columns;
      adapter.setImageSize(size);
    }
  }

  private void refreshData() {
    if (checkPermission(PERMISSION_WRITE_STORAGE)) {
      adapter.startFetchPhoto();
    }
  }

  private void showLoading() {
    recyclerView.setVisibility(View.GONE);
    emptyLayout.setVisibility(View.GONE);
  }

  private void hideLoading() {
    recyclerView.setVisibility(View.VISIBLE);
    emptyLayout.setVisibility(View.GONE);
  }

  private void showEmpty() {
    recyclerView.setVisibility(View.GONE);
    emptyLayout.setVisibility(View.VISIBLE);
  }

  @Override
  protected void permissionAccepted(int requestCode) {
    if (requestCode == PERMISSION_WRITE_STORAGE) {
      refreshData();
    } else if (requestCode == PERMISSION_CAMERA) {
      openCamera();
    }
  }

  @Override
  protected void permissionRejected(int requestCode) {
//    UIUtils.showToast(App.getResString("permission.denied"));
    if (requestCode == PERMISSION_WRITE_STORAGE) {
      finish();
    }
  }

  @Override
  public void photoFetchSucceeded(int count) {
    if (count == 0) {
      showEmpty();
    } else {
      hideLoading();
    }
  }

  @Override
  public void photoFetchFailed() {
    showEmpty();
  }

  @Override
  public void onePhotoSelected(String path) {
//    setStringResult(Const.ONE_PHOTO_RESULT_CODE, path);
    finish();
  }

  private void photoSelected(ArrayList<String> list) {
    Intent i = new Intent();
    i.putStringArrayListExtra(Const.PHOTO_INTENT_KEY, list);
    setResult(Const.PHOTO_RESULT_CODE, i);
    finish();
  }

  @Override
  public void photoSelected(int count) {
    getBigBar().setMenuState(
        ActionType.DONE,
        count > 0 ? MenuState.VISIBLE : MenuState.DISABLED);
  }

  @Override
  public MarginBox getMargin(int index) {
    if (index < columns) {
      return new MarginBox(photoMargin, photoMargin * 2, photoMargin, photoMargin * 2);
    }
    return new MarginBox(photoMargin, 0, photoMargin, photoMargin * 2);
  }

  @Override
  public void optionClicked(ActionType actionType) {
    super.optionClicked(actionType);
    switch (actionType) {
      case BACK:
        onBackPressed();
        break;

      case CAMERA:
        openCamera();
        break;

      case DONE:
        photoSelected(adapter.getSelectedNames());
        break;
    }
  }

  private void openCamera() {
    if (checkPermission(PERMISSION_CAMERA)) {
      RxImagePicker.with(this).requestImage().subscribe(new Action1<String>() {
        @Override
        public void call(String s) {
          if (s != null) {
            ArrayList<String> singleton = new ArrayList<>();
            singleton.add(s);
            photoSelected(singleton);
          }
        }
      });
    }
  }
}
