package com.zoyi.channel.plugin.android.activity.camera;

/**
 * Created by mika on 2016. 4. 27..
 */

import android.content.Context;
import android.content.Intent;
import com.zoyi.rx.Observable;
import com.zoyi.rx.subjects.PublishSubject;

public class RxImagePicker {
  private static RxImagePicker instance;

  public static synchronized RxImagePicker with(Context context) {
    if (instance == null) {
      instance = new RxImagePicker(context.getApplicationContext());
    }
    return instance;
  }

  private Context context;
  private PublishSubject<String> publishSubject;

  private RxImagePicker(Context context) {
    this.context = context;
  }

  public Observable<String> requestImage() {
    publishSubject = PublishSubject.create();
    startImagePickHiddenActivity();
    return publishSubject;
  }

  void onImagePicked(String path) {
    if (publishSubject != null) {
      publishSubject.onNext(path);
      publishSubject.onCompleted();
    }
  }

  private void startImagePickHiddenActivity() {
    Intent intent = new Intent(context, HiddenActivity.class);
    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
    context.startActivity(intent);
  }
}