package com.zoyi.channel.plugin.android;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.PushBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;

/**
 * Created by mika on 2017. 1. 24..
 */
public class ChannelView extends RelativeLayout {
  View pushLayout;
  AvatarLayout avatarLayout;
  TextView textName, textMessage;
  FloatingActionButton fab;

  private Context context;
  private Animation pushAnimation;
  private Subscription subscription;
  private UserChat userChat;

  public ChannelView(Context context) {
    super(context);
  }

  public ChannelView(Context context, AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  private void init(final Context context, AttributeSet attrs) {
    this.context = context;

    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_channel_view, this);
    fab = (FloatingActionButton) view.findViewById(R.id.fab);
    fab.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        ChannelPlugin.launch(ChannelView.this.context);
      }
    });

    pushLayout = view.findViewById(R.id.push_layout);
    avatarLayout = (AvatarLayout) view.findViewById(R.id.push_avatar);
    textName = (TextView) view.findViewById(R.id.push_name);
    textMessage = (TextView) view.findViewById(R.id.push_message);

    pushAnimation = AnimationUtils.loadAnimation(getContext(), R.anim.push);
    pushAnimation.setAnimationListener(new Animation.AnimationListener() {
      @Override
      public void onAnimationStart(android.view.animation.Animation animation) {
        pushLayout.setVisibility(VISIBLE);
      }

      @Override
      public void onAnimationEnd(android.view.animation.Animation animation) {
        hidePush();
      }

      @Override
      public void onAnimationRepeat(android.view.animation.Animation animation) {
      }
    });

    view.findViewById(R.id.push_close).setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        hidePush();
      }
    });

    pushLayout.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        String chatId = userChat != null ? userChat.getId() : null;
        IntentUtils.setNextActivity(context, UserChatListActivity.class)
            .putExtra("chatId", chatId)
            .startActivity();
      }
    });
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();
    subscription = RxBus.observable()
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new Action1<Object>() {
      @Override
      public void call(Object o) {
        if (o instanceof CommandBus) {
          CommandBus commandBus = (CommandBus) o;
          switch (commandBus.getCommand()) {
            case CHECKED_IN:
              if (commandBus.getObject() != null && commandBus.getObject() instanceof Plugin) {
                checkedIn((Plugin) commandBus.getObject());
              }
              break;

            case CHECKED_OUT:
              checkedOut();
              break;
          }
        }

        if (o instanceof PushBus) {
          PushBus pushBus = (PushBus) o;
          showPush(pushBus.getProfileEntity(), pushBus.getMessage(), pushBus.getUserChat());
        }
      }
    });
    if (ChannelPlugin.getPlugin() != null) {
      checkedIn(ChannelPlugin.getPlugin());
    }
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();
    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
    }
  }

  private void checkedIn(Plugin plugin) {
    if (plugin != null) {
      setVisibility(VISIBLE);
      fab.setColorNormal(plugin.getBackgroundColor());
      fab.setColorPressed(Utils.addBlackMask(plugin.getBackgroundColor()));
      fab.setColorRipple(Color.WHITE);
      fab.setImageResource(
          plugin.getTextColor() == Color.BLACK
              ? R.drawable.ch_plugin_balloon_black
              : R.drawable.ch_plugin_balloon);
      fab.setVisibility(VISIBLE);
    }
  }

  private void checkedOut() {
    setVisibility(GONE);
  }

  private void showPush(ProfileEntity person, String message, UserChat userChat) {
    this.userChat = userChat;

    avatarLayout.set(person);
    if (person != null && person.getName() != null) {
      textName.setText(person.getName());
    } else {
      textName.setText(Utils.getString(context, "ch.unknown"));
    }
    textMessage.setText(message != null ? message : "");

    pushLayout.setVisibility(VISIBLE);
    pushLayout.startAnimation(pushAnimation);
  }

  private void hidePush() {
    this.userChat = null;

    pushLayout.clearAnimation();
    pushLayout.setVisibility(GONE);
  }
}
