package com.zoyi.channel.plugin.android;

import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ScriptsWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by mika on 2017. 2. 7..
 */
public class ChannelStore {
  private static Subscription subscription;
  private static Map<String, Script> scriptMap;

  static Channel channel;
  static String veilId;
  static User user;
  static Veil veil;

  static void startFetchPlugin() {
    stopFetchPlugin();
    subscription = Observable.interval(3, TimeUnit.MINUTES)
        .subscribe(new Subscriber<Long>() {
          @Override
          public void onCompleted() {
          }

          @Override
          public void onError(Throwable e) {
          }

          @Override
          public void onNext(Long aLong) {
            fetchPlugin();
          }
        });
  }

  static void stopFetchPlugin() {
    if (subscription != null && !subscription.isUnsubscribed()) {

      subscription.unsubscribe();
    }
  }

  private static void fetchPlugin() {
    if (ChannelPlugin.pluginId != null) {
      ChannelPlugin.getService().getPlugin(ChannelPlugin.pluginId)
          .subscribeOn(Schedulers.newThread())
          .observeOn(AndroidSchedulers.mainThread())
          .subscribe(new RestSubscriber<PluginWrapper>() {
            @Override
            public void onNext(PluginWrapper pluginWrapper) {
              if (pluginWrapper != null) {
                ChannelStore.channel = pluginWrapper.getChannel();
              }
            }
          });
    }
  }

  static void fetchScripts() {
    ChannelPlugin.getService().getScripts()
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(new RestSubscriber<ScriptsWrapper>() {
          @Override
          public void onNext(ScriptsWrapper scriptsWrapper) {
            setScripts(scriptsWrapper.getScripts());
          }
        });
  }

  private static void setScripts(List<Script> scripts) {
    if (scriptMap == null) {
      scriptMap = new HashMap<>();
    }

    if (scripts != null) {
      scriptMap = new HashMap<>();
      for (Script script : scripts) {
        if (script.getKey() != null) {
          scriptMap.put(script.getKey(), script);
        }
      }
    }
  }

  public static String getScript(String key, String resourceKey) {
    if (scriptMap != null && scriptMap.containsKey(key)) {
      String locale = Locale.getDefault().getLanguage();
      if (scriptMap.get(key).getMessage(locale) != null) {
        return scriptMap.get(key).getMessage(locale);
      }
    }
    if (ChannelPlugin.getApplication() != null) {
      return Utils.getString(ChannelPlugin.getApplication(), resourceKey);
    }
    return "";
  }

  public static String getChannelId() {
    if (channel != null) {
      return channel.getId();
    }
    return null;
  }

  public static Channel getChannel() {
    return channel;
  }

  public static String getUserName() {
    if (user != null) {
      return user.getName();
    }
    return null;
  }

  public static String getMobileNumber() {
    if (user != null) {
      return user.getMobileNumber();
    }
    if (veil != null) {
      return veil.getMobileNumber();
    }
    return null;
  }

  public static String getPersonType() {
    if (user != null) {
      return User.CLASSNAME;
    }
    return Veil.CLASSNAME;
  }

  public static String getPersonId() {
    if (user != null) {
      return user.getId();
    }
    return veilId;
  }

  public static String getVeilId() {
    return veilId;
  }

  public static String getUserId() {
    if (user != null) {
      return user.getId();
    }
    return null;
  }

  public static boolean isWorking() {
    if (channel != null) {
      return channel.isWorking();
    }
    return false;
  }

  public static boolean hasName() {
    if (user != null) {
      return !user.isGhost();
    }
    if (veil != null) {
      return !veil.isGhost();
    }
    return true;
  }

  public static void setUserVeil(User user, Veil veil) {
    if (user != null) {
      ChannelStore.user = user;
    }
    if (veil != null) {
      ChannelStore.veil = veil;
    }
  }
}
