package com.zoyi.channel.plugin.android.fcm;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.zoyi.channel.plugin.android.ChannelIO;

import java.util.Map;

public class ChannelFirebaseMessagingService extends FirebaseMessagingService {

  @Override
  public void onNewToken(String refreshedToken) {
    ChannelIO.initPushToken(refreshedToken);
  }

  @Override
  public void onMessageReceived(RemoteMessage remoteMessage) {
    Map<String, String> messages = remoteMessage.getData();

    if (ChannelIO.isChannelPushNotification(messages)) {
      ChannelIO.showPushNotification(getApplication(), messages);
    }
  }
}
