/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.viewgroup;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;

public class MaxWidthLinearLayout
extends LinearLayout {
    private int maxWidth = Integer.MAX_VALUE;

    public MaxWidthLinearLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaxWidthLinearLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaxWidthLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaxWidthLinearLayout);
            try {
                this.maxWidth = typedArray.getDimensionPixelSize(R.styleable.MaxWidthLinearLayout_ch_mwll_maxWidth, this.maxWidth);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.maxWidth > 0 && this.maxWidth < measuredWidth) {
            int measureMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxWidth, (int)measureMode);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

