/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.video_player.AbsPopUpVideoPlayerView;
import com.zoyi.channel.plugin.android.view.video_player.OnFullScreenPopUpClickListener;
import com.zoyi.rx.Subscription;

public class FullScreenPopUpVideoPlayerView
extends AbsPopUpVideoPlayerView {
    private View buttonVideoVolumeOn;
    private View buttonVideoVolumeOff;
    @Nullable
    private Subscription hideControllerSubscription;
    @Nullable
    private OnFullScreenPopUpClickListener listener;

    public FullScreenPopUpVideoPlayerView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public FullScreenPopUpVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FullScreenPopUpVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.buttonVideoVolumeOn = this.findViewById(R.id.ch_buttonVideoVolumeOn);
        this.buttonVideoVolumeOff = this.findViewById(R.id.ch_buttonVideoVolumeOff);
        this.buttonVideoVolumeOn.setOnClickListener(v -> {
            this.applyVolumeButton(false);
            if (this.listener != null) {
                this.listener.onFullScreenPopUpClick();
            }
        });
        this.buttonVideoVolumeOff.setOnClickListener(v -> {
            this.applyVolumeButton(true);
            if (this.listener != null) {
                this.listener.onFullScreenPopUpClick();
            }
        });
    }

    @Override
    protected int getLayoutId() {
        return R.layout.ch_view_popup_fullscreen_video_player;
    }

    @Override
    public FullScreenPopUpVideoPlayerView setUrl(@Nullable String messageId, File attachment) {
        super.setUrl(messageId, attachment);
        this.applyVolumeButton(false);
        return this;
    }

    public FullScreenPopUpVideoPlayerView setListener(@Nullable View.OnClickListener l, @Nullable OnFullScreenPopUpClickListener listener) {
        super.setOnClickListener(l);
        this.listener = listener;
        return this;
    }

    private void applyVolumeButton(boolean isVolumeOn) {
        if (this.exoPlayer != null) {
            this.exoPlayer.setVolume(isVolumeOn ? 1.0f : 0.0f);
        }
        Views.setVisibility(this.buttonVideoVolumeOn, isVolumeOn);
        Views.setVisibility(this.buttonVideoVolumeOff, !isVolumeOn);
        this.changeVideoVolumeState(isVolumeOn);
    }

    @Override
    public void clear() {
        super.clear();
        this.dispose(this.hideControllerSubscription);
        this.hideControllerSubscription = null;
    }
}

