/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.manager.ChatVideoManager;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

public abstract class AbsVideoPlayerView
extends FrameLayout {
    private Context context;
    @Nullable
    private Subscription playingStatusSubscription;
    @Nullable
    private String id;

    public AbsVideoPlayerView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public AbsVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AbsVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
    }

    protected void setId(String id2) {
        this.id = id2;
        this.playingStatusSubscription = ChatVideoManager.get().attachStopSignal().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(it -> {
            if (id2 != null && id2.equals(it)) {
                this.onVideoPaused();
            }
        });
    }

    public boolean getLatestVolumeState() {
        return (Boolean)Optional.ofNullable((Object)this.id).map(it -> ChatVideoManager.get().getVideoVolumeState((String)it)).orElse((Object)true);
    }

    public long getLatestSeconds() {
        return (Long)Optional.ofNullable((Object)this.id).map(it -> ChatVideoManager.get().getVideoPosition((String)it)).orElse((Object)0L);
    }

    protected void changeVideoState(boolean isPlaying) {
        if (isPlaying) {
            ChatVideoManager.get().onVideoStarted(this.context, this.id);
        } else {
            ChatVideoManager.get().onVideoStopped(this.context, this.id);
        }
    }

    protected void changeVideoPosition(@Nullable Long seconds) {
        if (seconds != null) {
            Optional.ofNullable((Object)this.id).ifPresent(it -> ChatVideoManager.get().onVideoProgressChanged((String)it, seconds));
        }
    }

    protected void changeVideoVolumeState(boolean isVolumeOn) {
        if (this.id != null) {
            ChatVideoManager.get().onVideoVolumeStateChanged(this.id, isVolumeOn);
        }
    }

    abstract void onVideoPaused();

    public void clear() {
        if (this.playingStatusSubscription != null && !this.playingStatusSubscription.isUnsubscribed()) {
            this.playingStatusSubscription.unsubscribe();
        }
        this.playingStatusSubscription = null;
        this.onVideoPaused();
        this.changeVideoState(false);
        this.id = null;
    }
}

