/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.MarketingAction;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.view.media_thumbnail.FullScreenPopUpMediaThumbnailView;
import com.zoyi.channel.plugin.android.view.popup.BasePopupView;
import java.util.Locale;

public class FullScreenPopupView
extends BasePopupView {
    public FullScreenPopupView(@NonNull Context context) {
        super(context);
    }

    public FullScreenPopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public FullScreenPopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.ch_plugin_view_push_full_screen;
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        ((FullScreenPopUpMediaThumbnailView)this.viewPopUpMedia).setOnFullScreenPopUpClickListener(() -> {
            if (this.item != null) {
                MarketingAction.sendClickEvent(this.item.getMarketing(), null);
            }
        });
    }

    @Override
    public void show(Message message) {
        super.show(message);
        MarketingAction.sendViewEvent(message.getMarketing());
        File file = message.getPrimaryFile();
        if (file != null && !file.isPreviewable()) {
            this.viewFileRow.setVisibility(0);
            this.viewFileRow.setFile(file, message.getFiles().size());
        }
    }

    @Override
    protected void setMediaSize(Previewable previewable) {
        if (previewable.getHeight() != 0) {
            float maxRatio = 1.7777778f;
            float minRatio = 1.0f;
            float ratio = (float)previewable.getWidth().intValue() / previewable.getHeight().floatValue();
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.viewPopUpMedia.getLayoutParams();
            params.dimensionRatio = ratio < minRatio ? "1:1" : (ratio > maxRatio ? "16:9" : String.format(Locale.ENGLISH, "%d:%d", previewable.getWidth(), previewable.getHeight()));
        }
    }

    @Override
    public void resetView() {
        super.resetView();
    }

    @Override
    protected int getDefaultTextMaxLine() {
        return 8;
    }

    @Override
    protected int getAttachmentTextMaxLine() {
        return 4;
    }
}

