/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;

public class ChEndFlowLayout
extends ViewGroup {
    public int horizontalSpacing;
    public int verticalSpacing;

    public ChEndFlowLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public ChEndFlowLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ChEndFlowLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ChEndFlowLayout, 0, 0);
        try {
            this.horizontalSpacing = (int)typedArray.getDimension(R.styleable.ChEndFlowLayout_ch_fl_horizontalSpacing, 0.0f);
            this.verticalSpacing = (int)typedArray.getDimension(R.styleable.ChEndFlowLayout_ch_fl_verticalSpacing, 0.0f);
        }
        finally {
            typedArray.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
        int count = this.getChildCount();
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec) - this.getPaddingTop() - this.getPaddingBottom();
        int lineHeight = 0;
        int leftX = this.getPaddingLeft();
        int topY = 0;
        int childHeightMeasureSpec = View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE ? View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE), childHeightMeasureSpec);
            int childw = Math.min(width, child.getMeasuredWidth());
            if (leftX + childw > width) {
                leftX = childw + this.horizontalSpacing;
                topY += lineHeight + this.verticalSpacing;
                lineHeight = child.getMeasuredHeight();
                continue;
            }
            leftX += childw + this.horizontalSpacing;
            lineHeight = Math.max(lineHeight, child.getMeasuredHeight());
        }
        this.setMeasuredDimension(width + this.getPaddingLeft() + this.getPaddingRight(), topY + lineHeight + this.getPaddingTop() + this.getPaddingBottom());
    }

    private int appendChild(int startIndex, int endIndex, int rightX, int topY) {
        int rightPosition = rightX;
        int lineHeight = 0;
        for (int i = endIndex; i >= startIndex; --i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.layout(rightPosition - child.getMeasuredWidth(), topY, rightPosition, topY + child.getMeasuredHeight());
            rightPosition -= child.getMeasuredWidth() + this.horizontalSpacing;
            lineHeight = Math.max(lineHeight, child.getMeasuredHeight());
        }
        return lineHeight;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int width = r - l;
        int availableWidth = r - l - this.getPaddingLeft() - this.getPaddingRight();
        int leftX = 0;
        int topY = this.getPaddingTop();
        int lastQueuedIndex = 0;
        for (int i = 0; i <= count; ++i) {
            if (i == count) {
                this.appendChild(lastQueuedIndex, i - 1, width - this.getPaddingRight(), topY);
                continue;
            }
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childWidth = Math.min(child.getMeasuredWidth(), availableWidth);
            if (leftX + childWidth > availableWidth) {
                leftX = childWidth + this.horizontalSpacing;
                topY += this.appendChild(lastQueuedIndex, i - 1, width - this.getPaddingRight(), topY) + this.verticalSpacing;
                lastQueuedIndex = i;
                continue;
            }
            leftX += childWidth + this.horizontalSpacing;
        }
    }
}

