/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.integrations.instagram;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramData;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramMediaEntity;
import com.zoyi.channel.plugin.android.view.integrations.instagram.InstagramMediaView;
import java.util.ArrayList;
import java.util.List;

public class InstagramMediaAdapter
extends PagerAdapter {
    private Context context;
    private ArrayList<InstagramMediaEntity> items = new ArrayList();
    private List<InstagramMediaView> views = new ArrayList<InstagramMediaView>();
    private boolean isVolumeOn = false;

    public InstagramMediaAdapter(Context context) {
        this.context = context;
    }

    public void setItems(InstagramData data) {
        this.items.clear();
        this.items.addAll(data.getData());
        this.views = new ArrayList<InstagramMediaView>();
        for (int i = 0; i < data.getData().size(); ++i) {
            this.views.add(null);
        }
        this.notifyDataSetChanged();
    }

    public void onPageChanged(int position) {
        for (int i = 0; i < this.views.size(); ++i) {
            InstagramMediaView view = this.views.get(i);
            if (view == null) continue;
            if (i == position) {
                view.onActive();
                continue;
            }
            view.onDeactive();
        }
    }

    @Nullable
    private InstagramMediaEntity getItem(int position) {
        if (position >= 0 && position < this.items.size()) {
            return this.items.get(position);
        }
        return null;
    }

    public void changeVideoVolumeState(boolean isVolumeOn) {
        this.isVolumeOn = isVolumeOn;
        for (InstagramMediaView view : this.views) {
            if (view == null) continue;
            view.changeVideoVolumeState(isVolumeOn);
        }
    }

    public int getCount() {
        return this.items.size();
    }

    public int getItemPosition(@NonNull Object object) {
        return -2;
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object o) {
        return view.equals(o);
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (container != null && object instanceof View) {
            if (object instanceof InstagramMediaView) {
                ((InstagramMediaView)((Object)object)).clear();
            }
            if (position < this.views.size()) {
                this.views.set(position, null);
            }
            container.removeView((View)object);
        }
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        InstagramMediaView view = new InstagramMediaView(this.context);
        InstagramMediaEntity item = this.getItem(position);
        if (item != null) {
            view.setData(item, this.isVolumeOn);
        }
        container.addView((View)view);
        if (position < this.views.size()) {
            this.views.set(position, view);
        }
        return view;
    }
}

