/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.dialog.bottom_sheet.icon_button;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class IconButtonView
extends FrameLayout {
    private AppCompatImageView imageIconButton;
    private TextView textIconButton;

    public IconButtonView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public IconButtonView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public IconButtonView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_view_icon_button, (ViewGroup)this, true);
        this.imageIconButton = (AppCompatImageView)view.findViewById(R.id.ch_imageIconButton);
        this.textIconButton = (TextView)view.findViewById(R.id.ch_textIconButton);
    }

    public void setData(@DrawableRes int iconDrawableId, String messageText, int iconColorId, int textColorId) {
        if (iconDrawableId != 0) {
            this.imageIconButton.setImageResource(iconDrawableId);
        }
        if (iconColorId != 0) {
            this.imageIconButton.setColorFilter(ResUtils.getColor(iconColorId));
        }
        if (messageText != null) {
            this.textIconButton.setText((CharSequence)messageText);
        }
        if (textColorId != 0) {
            this.textIconButton.setTextColor(ResUtils.getColor(textColorId));
        }
    }
}

