/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.coordinator;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import com.zoyi.channel.plugin.android.view.coordinator.OnBottomScrollableStateChangeListener;

public class PaddingNestedScrollView
extends NestedScrollView {
    @Nullable
    private OnBottomScrollableStateChangeListener listener;
    @Nullable
    private Boolean isBottomScrollable = null;

    public PaddingNestedScrollView(@NonNull Context context) {
        super(context);
    }

    public PaddingNestedScrollView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PaddingNestedScrollView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setListener(@Nullable OnBottomScrollableStateChangeListener listener) {
        this.listener = listener;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int y = (int)ev.getY();
        if (y < this.getPaddingTop() - this.getScrollY()) {
            switch (ev.getAction()) {
                case 0: {
                    return false;
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        boolean isBottomScrollable = this.canScrollVertically(1);
        if (this.isBottomScrollable == null || this.isBottomScrollable != isBottomScrollable) {
            this.isBottomScrollable = isBottomScrollable;
            if (this.listener != null) {
                this.listener.onBottomScrollableStateChanged(isBottomScrollable);
            }
        }
    }
}

