/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriUtils {
    private static final String INTENT_URI_PREFIX = "intent:";
    public static final String TEL_URI_PREFIX = "tel:";
    public static final String MAILTO_URI_PREFIX = "mailto:";
    private static final String FALLBACK_URL_PREFIX = "browser_fallback_url";

    public static boolean isIntentUri(@Nullable String uri) {
        return uri != null && uri.toLowerCase().startsWith(INTENT_URI_PREFIX);
    }

    public static boolean isMailToUri(@Nullable String uri) {
        return uri != null && uri.startsWith(MAILTO_URI_PREFIX);
    }

    public static boolean isTelUri(@Nullable String uri) {
        return uri != null && uri.startsWith(TEL_URI_PREFIX);
    }

    public static boolean doFallBack(@Nullable Context context, @Nullable Intent parsedIntent) {
        if (context == null || parsedIntent == null) {
            return false;
        }
        String fallbackUrl = parsedIntent.getStringExtra(FALLBACK_URL_PREFIX);
        if (fallbackUrl != null) {
            try {
                context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)fallbackUrl)));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getCloudFrontUrl(@Nullable String bucket) {
        if (bucket == null) {
            return "http:///";
        }
        switch (bucket) {
            case "bin.exp.channel.io": {
                return "https://cf.exp.channel.io";
            }
            case "bin.channel.io": {
                return "https://cf.channel.io";
            }
        }
        return String.format("http://%s", bucket);
    }

    public static String getCloudFrontUrl() {
        if ("exp".equals("exp")) {
            return "https://cf.exp.channel.io";
        }
        return "https://cf.channel.io";
    }

    @Nullable
    public static String getYouTubeVideoId(@Nullable String url) {
        try {
            if (url != null) {
                String videoId = Uri.parse((String)url).getQueryParameter("v");
                if (videoId != null) {
                    return videoId;
                }
                Matcher matcher = Pattern.compile("(?<=watch\\?v=|/videos/|embed\\/|youtu.be\\/|\\/v\\/|\\/e\\/|watch\\?v%3D|watch\\?feature=player_embedded&v=|%2Fvideos%2F|embed%\u200c\u200b2F|youtu.be%2F|%2Fv%2F)[^#\\&\\?\\n]*", 2).matcher(url);
                if (matcher.find()) {
                    return matcher.group();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

