/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.activity.video.VideoViewerActivity;
import com.zoyi.channel.plugin.android.enumerate.LinkType;
import com.zoyi.channel.plugin.android.global.ChannelFileProvider;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Executor {
    private static File tempPhotoFile = null;

    public static boolean takePhoto(Activity activity) {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        File photoFile = Executor.getPhotoFile((Context)activity);
        if (photoFile == null) {
            return false;
        }
        tempPhotoFile = photoFile;
        takePictureIntent.putExtra("output", (Parcelable)ChannelFileProvider.getUriForFile((Context)activity, photoFile));
        if (takePictureIntent.resolveActivity(activity.getPackageManager()) != null) {
            activity.startActivityForResult(takePictureIntent, 3000);
            return true;
        }
        return false;
    }

    public static void startFileMediaScan(Activity activity, String filePath) {
        Executor.startFileMediaScan(activity, new File(filePath));
    }

    public static void startFileMediaScan(Activity activity, File file) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        mediaScanIntent.setData(Uri.fromFile((File)file));
        activity.sendBroadcast(mediaScanIntent);
    }

    public static void executeLinkAction(@Nullable Context context, @Nullable String link, LinkType linkType) {
        if (context != null && link != null) {
            boolean handleLink = false;
            com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener listener = ChannelIO.getListener();
            if (listener != null) {
                handleLink = listener.onUrlClicked(link);
            }
            ChannelPluginListener legacyListener = ChannelIO.getLegacyListener();
            if (!handleLink && legacyListener != null) {
                handleLink = legacyListener.onClickChatLink(link);
            }
            if (!handleLink) {
                switch (linkType) {
                    case URL: {
                        IntentUtils.setUrl(context, link).startActivity();
                        break;
                    }
                    case EMAIL: {
                        IntentUtils.setEmail(context, link).startActivity();
                    }
                }
            }
        }
    }

    public static File getTempPhotoFile() {
        return tempPhotoFile;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private static File getPhotoFile(Context context) {
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            return File.createTempFile(timeStamp, ".jpg", context.getCacheDir());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean canCall(Context context) {
        return context != null && context.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    public static void openEmail(Context context, @Nullable String email) {
        if (TextUtils.isEmpty((CharSequence)email)) {
            return;
        }
        IntentUtils.setEmail(context, email).startActivity();
    }

    public static void openCall(Context context, @Nullable String phoneNumber) {
        if (TextUtils.isEmpty((CharSequence)phoneNumber) || !Executor.canCall(context)) {
            return;
        }
        IntentUtils.setPhone(context, ParseUtils.parsePhoneNumber(context, phoneNumber)).startActivity();
    }

    public static void startFullScreenVideo(Context context, com.zoyi.channel.plugin.android.model.rest.File attachment, long startAt) {
        IntentUtils.setNextActivity(context, VideoViewerActivity.class).putExtra("filename", attachment.getName()).putExtra("url", attachment.getUrl()).putExtra("EXTRA_START_AT", startAt).startActivity();
    }
}

