/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.okhttp3.MediaType;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.okio.BufferedSink;
import com.zoyi.rx.functions.Action1;
import java.io.IOException;
import java.io.InputStream;

public class ProgressRequestBody
extends RequestBody {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private Uri uri;
    @Nullable
    private String name;
    @Nullable
    private MediaType mediaType;
    @Nullable
    private ContentResolver contentResolver;
    private long size;
    @NonNull
    private Action1<Integer> progressAction;

    public ProgressRequestBody(Uri uri, @Nullable String name, long size, @NonNull Action1<Integer> progressAction) {
        this.uri = uri;
        this.name = name;
        this.size = size;
        this.mediaType = (MediaType)Optional.ofNullable((Object)name).map(FilenameUtils::getExtension).map(extension -> MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension)).map(MediaType::parse).orElse((Object)MediaType.parse((String)"application/octet-stream"));
        this.contentResolver = (ContentResolver)Optional.ofNullable((Object)ChannelIO.getAppContext()).map(Context::getContentResolver).orElse(null);
        this.progressAction = progressAction;
    }

    @NonNull
    public String getName() {
        return (String)Optional.ofNullable((Object)this.name).orElse((Object)"file");
    }

    @Nullable
    public MediaType contentType() {
        return this.mediaType;
    }

    public long contentLength() {
        return this.size;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        long fileLength = this.contentLength();
        byte[] buffer = new byte[2048];
        if (this.contentResolver != null) {
            try (InputStream in = this.contentResolver.openInputStream(this.uri);){
                long uploaded = 0L;
                int lastProgressPercentUpdate = -1;
                int read = in.read(buffer);
                while (read != -1) {
                    sink.write(buffer, 0, read);
                    read = in.read(buffer);
                    int progress = Math.min((int)((uploaded += (long)read) * 100L / Math.max(1L, fileLength)), 100);
                    if (progress == lastProgressPercentUpdate && progress != 100) continue;
                    this.progressAction.call((Object)progress);
                    lastProgressPercentUpdate = progress;
                }
            }
        }
    }
}

