/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.common.navigation;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.badge.AlertBadge;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.selector.UserSelector;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.ContextUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.RxUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.button.MaskImageButton;
import com.zoyi.channel.plugin.android.view.button.TextButton;
import com.zoyi.channel.plugin.android.view.button.ThemeEffectiveView;
import com.zoyi.channel.plugin.android.view.textview.CHTextView;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;
import java.util.ArrayList;
import java.util.List;

public class NavigationView
extends LinearLayout {
    private Context context;
    private MaskImageButton buttonBack;
    private AlertBadge alertBadge;
    private ViewGroup contentContainer;
    private LinearLayout actionContainer;
    @Nullable
    private CHTextView textTitle;
    @Nullable
    private Binder dataBinder;
    @Nullable
    private Binder userBinder;
    private boolean hideAlertBadge = false;
    private boolean badgeNotInit = true;
    private int backColor = -16777216;
    private int textColor = -1;
    private List<ThemeEffectiveView> views;
    @Nullable
    private Subscription badgeSubscription;

    public NavigationView(Context context) {
        super(context);
        this.init(context, null);
    }

    public NavigationView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public NavigationView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.context = context;
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_navigation, (ViewGroup)this, true);
        this.buttonBack = (MaskImageButton)root.findViewById(R.id.ch_buttonNavigationBack);
        this.buttonBack.setOnClickListener(v -> this.onBackClick());
        this.alertBadge = (AlertBadge)root.findViewById(R.id.ch_alertNavigation);
        this.contentContainer = (ViewGroup)root.findViewById(R.id.ch_layoutNavigationContent);
        this.actionContainer = (LinearLayout)root.findViewById(R.id.ch_layoutNavigationActions);
        this.textTitle = (CHTextView)root.findViewById(R.id.ch_textNavigationTitle);
        this.views = new ArrayList<ThemeEffectiveView>();
        String titleKey = null;
        String title = null;
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.NavigationView, 0, 0);
            try {
                titleKey = typedArray.getString(R.styleable.NavigationView_ch_nv_titleKey);
                title = typedArray.getString(R.styleable.NavigationView_ch_nv_title);
                this.hideAlertBadge = typedArray.getBoolean(R.styleable.NavigationView_ch_nv_hideAlertBadge, this.hideAlertBadge);
            }
            finally {
                typedArray.recycle();
            }
        }
        if (this.textTitle != null) {
            if (titleKey != null) {
                this.textTitle.setTextKey(titleKey);
            } else if (title != null) {
                this.textTitle.setText(title);
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.dataBinder = PluginSelector.bindPlugin((Action1<Plugin>)((Action1)plugin -> {
            this.backColor = plugin.getBackgroundColor();
            this.textColor = plugin.getTextColor();
            this.buttonBack.setColor(this.textColor);
            this.alertBadge.setTheme(this.backColor, this.textColor);
            if (this.textTitle != null) {
                this.textTitle.setTextColor(this.textColor);
            }
            if (this.views != null) {
                for (ThemeEffectiveView view : this.views) {
                    if (view == null) continue;
                    view.onThemeChange(this.backColor, this.textColor);
                }
            }
        }));
        this.userBinder = UserSelector.bindUserAlertCount((Action1<Integer>)((Action1)count -> {
            if (this.badgeNotInit) {
                this.badgeNotInit = false;
                this.setAlertBadge((int)count);
            } else {
                this.badgeSubscription = RxUtils.debounce(this.badgeSubscription, 600L, () -> this.setAlertBadge((int)count));
            }
        }));
    }

    private void setAlertBadge(int count) {
        if (!this.hideAlertBadge && count > 0) {
            this.alertBadge.setCount(count);
            this.alertBadge.setVisibility(0);
        } else {
            this.alertBadge.setVisibility(4);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.dataBinder != null) {
            this.dataBinder.unbind();
        }
        if (this.userBinder != null) {
            this.userBinder.unbind();
        }
        if (this.views != null) {
            this.views.clear();
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child == null) {
            return;
        }
        if (CompareUtils.exists((Comparable)Integer.valueOf(child.getId()), (Comparable[])new Integer[]{R.id.ch_rootNavigation, R.id.ch_buttonNavigationBack, R.id.ch_alertNavigation, R.id.ch_layoutNavigationContent, R.id.ch_layoutNavigationActions})) {
            super.addView(child, index, params);
        } else if (this.contentContainer != null) {
            if (this.textTitle != null) {
                this.contentContainer.removeAllViews();
                this.textTitle = null;
            }
            if (child instanceof ThemeEffectiveView) {
                ((ThemeEffectiveView)child).onThemeChange(this.backColor, this.textColor);
                this.addThemeEffectiveView((ThemeEffectiveView)child);
            }
            this.contentContainer.addView(child);
        }
    }

    private void onBackClick() {
        Activity activity = ContextUtils.getActivity(this.context);
        if (activity != null) {
            activity.finish();
        }
    }

    private void addThemeEffectiveView(ThemeEffectiveView themeEffectiveView) {
        if (this.views != null) {
            this.views.add(themeEffectiveView);
        }
    }

    public void setTitle(String title) {
        if (this.textTitle != null) {
            this.textTitle.setText(title);
        }
    }

    @Nullable
    public View addAction(String text, View.OnClickListener listener) {
        if (this.actionContainer != null) {
            TextButton button = new TextButton(this.context);
            button.setText(text);
            button.setTextColor(this.textColor);
            button.setOnClickListener(listener);
            this.addThemeEffectiveView(button);
            this.actionContainer.addView((View)button);
            return button;
        }
        return null;
    }

    @Nullable
    public View addAction(int resId, View.OnClickListener listener) {
        return this.addAction(resId, 30.0f, listener);
    }

    @Nullable
    public View addAction(int resId, float iconDp, View.OnClickListener listener) {
        if (this.actionContainer != null) {
            MaskImageButton button = new MaskImageButton(this.context);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams((int)Utils.dpToPx(30.0f), (int)Utils.dpToPx(30.0f));
            if (iconDp < 30.0f) {
                int padding = (int)Utils.dpToPx((30.0f - iconDp) / 2.0f);
                button.setPadding(padding, padding, padding, padding);
            }
            if (this.actionContainer.getChildCount() > 0) {
                layoutParams.setMargins((int)Utils.dpToPx(18.0f), 0, 0, 0);
            }
            button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            button.setMask(resId);
            button.setColor(this.textColor);
            button.setOnClickListener(listener);
            this.addThemeEffectiveView(button);
            this.actionContainer.addView((View)button);
            return button;
        }
        return null;
    }
}

