/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnLinkButtonActionListener;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.MessageLinkButtonView;
import com.zoyi.channel.plugin.android.enumerate.ButtonTheme;
import com.zoyi.channel.plugin.android.model.rest.Block;
import com.zoyi.channel.plugin.android.model.rest.Button;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.BorderBackgroundView;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;
import com.zoyi.channel.plugin.android.view.layout.message.TextMessageView;
import com.zoyi.com.annimon.stream.Stream;
import java.util.List;

public abstract class AbsMessageTextView
extends LinearLayout {
    private BorderBackgroundView backHead;
    private BorderBackgroundView backContext;
    private ChBorderLayout layoutMessage;
    private TextMessageView textMessage;
    private LinearLayout layoutLinkButtons;
    private TextView textDelete;
    @Nullable
    private OnLinkButtonActionListener listener;

    public AbsMessageTextView(Context context) {
        super(context);
        this.init(context);
    }

    public AbsMessageTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AbsMessageTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(this.getLayoutId(), (ViewGroup)this, true);
        this.backHead = (BorderBackgroundView)view.findViewById(R.id.ch_viewMessageHolderHeadBorder);
        this.backContext = (BorderBackgroundView)view.findViewById(R.id.ch_viewMessageHolderContextBorder);
        this.layoutMessage = (ChBorderLayout)view.findViewById(R.id.ch_layoutMessageHolder);
        this.layoutLinkButtons = (LinearLayout)view.findViewById(R.id.ch_layoutMessageHolderLinkButtons);
        this.textMessage = (TextMessageView)view.findViewById(R.id.ch_textMessageHolder);
        this.textDelete = (TextView)view.findViewById(R.id.ch_textMessageHolderDelete);
    }

    public void setLinkButtonActionListener(OnLinkButtonActionListener listener) {
        this.listener = listener;
    }

    public void setHead(boolean isHead) {
        Views.setVisibility((View)this.backHead, isHead);
        Views.setVisibility((View)this.backContext, !isHead);
    }

    public void setText(@NonNull CharSequence text) {
        this.textMessage.setVisibility(0);
        this.textMessage.setText(text);
    }

    public void setBlocks(@NonNull List<Block> blocks) {
        this.textMessage.setVisibility(0);
        this.textMessage.setBlocks(blocks);
    }

    public void setLinkButtons(@NonNull List<Button> buttons) {
        if (this.layoutMessage != null) {
            try {
                ViewGroup.LayoutParams lp = this.layoutMessage.getLayoutParams();
                lp.width = -1;
                this.layoutMessage.setLayoutParams(lp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.layoutLinkButtons.setVisibility(0);
        Stream.of(buttons).forEach(button -> {
            MessageLinkButtonView linkButtonView = new MessageLinkButtonView(this.getContext());
            linkButtonView.setText(button.getTitle());
            if (button.getTheme() != null) {
                linkButtonView.setMessageTheme(ButtonTheme.fromString(button.getTheme()));
            }
            linkButtonView.setOnClickListener(v -> {
                if (this.listener != null) {
                    this.listener.onLinkButtonClick(button.getUrl());
                }
            });
            linkButtonView.setOnLongClickListener(v -> {
                if (this.listener != null) {
                    this.listener.onLinkButtonLongClick();
                }
                return false;
            });
            this.layoutLinkButtons.addView((View)linkButtonView);
        });
    }

    public void setDelete() {
        this.textDelete.setVisibility(0);
    }

    public void initViews() {
        this.setVisibility(8);
        if (this.layoutMessage != null) {
            try {
                ViewGroup.LayoutParams lp = this.layoutMessage.getLayoutParams();
                lp.width = -2;
                this.layoutMessage.setLayoutParams(lp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.textMessage != null) {
            this.textMessage.setVisibility(8);
        }
        if (this.layoutLinkButtons != null) {
            this.resetLinkButtons();
        }
        if (this.textDelete != null) {
            this.textDelete.setVisibility(8);
        }
    }

    private void resetLinkButtons() {
        if (this.layoutLinkButtons != null) {
            this.layoutLinkButtons.setVisibility(8);
            this.layoutLinkButtons.removeAllViews();
        }
    }

    protected void setBackColor(int backColor) {
        this.backHead.setColor(backColor);
        this.backContext.setColor(backColor);
        this.layoutMessage.setBackColor(backColor);
        this.layoutMessage.setBorderColor(backColor);
    }

    protected void setDeleteColor(int textColor) {
        this.textDelete.setTextColor(textColor);
    }

    protected abstract int getLayoutId();
}

