/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.profilebot;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnProfileBotSubmitListener;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.util.Initializer;

public abstract class BaseProfileBotInputView
extends FrameLayout {
    protected Context context;
    @Nullable
    private OnProfileBotSubmitListener listener;
    @Nullable
    private String key;
    @Nullable
    private FetchState fetchState;

    public BaseProfileBotInputView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public BaseProfileBotInputView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BaseProfileBotInputView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        View root = LayoutInflater.from((Context)context).inflate(this.getLayoutId(), (ViewGroup)this, true);
        this.initView(root);
    }

    protected void submit() {
        this.submit(this.getValue());
    }

    protected void submit(@Nullable Object value) {
        if (this.listener != null && this.key != null && this.fetchState != FetchState.LOADING) {
            this.listener.onSubmit(this.key, value);
        }
    }

    public void setValue(String key, @Nullable Object value, FetchState fetchState) {
        this.key = key;
        this.fetchState = fetchState;
        this.restore(value, fetchState);
    }

    public void setListener(OnProfileBotSubmitListener listener) {
        this.listener = listener;
    }

    protected abstract void initView(View var1);

    @Nullable
    protected abstract Object getValue();

    protected abstract void restore(@Nullable Object var1, FetchState var2);

    public abstract void focus();

    protected abstract int getLayoutId();

    public void onRecycled() {
        if (this.key != null) {
            ProfileBotStore.get().inputKey.set(this.key);
            ProfileBotStore.get().inputValue.set(this.getValue());
        }
    }
}

