/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.attachment;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.contentview.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.MessageContentView;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.media_thumbnail.FileAttachmentView;
import com.zoyi.channel.plugin.android.view.media_thumbnail.MediaThumbnailView;
import com.zoyi.channel.plugin.android.view.media_thumbnail.OriginAttachmentMediaThumbnailView;
import com.zoyi.com.annimon.stream.Stream;
import java.util.List;

public class AttachmentGroupLinearLayout
extends LinearLayout
implements MessageContentView {
    private Context context;

    public AttachmentGroupLinearLayout(Context context) {
        super(context);
        this.init(context);
    }

    public AttachmentGroupLinearLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AttachmentGroupLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.setOrientation(1);
    }

    public void setAttachments(@Nullable String messageId, List<File> files, @Nullable OnAttachmentContentActionListener listener) {
        this.clear();
        Stream.ofNullable(files).forEach(file -> {
            switch (file.getType()) {
                case "video": 
                case "image": {
                    OriginAttachmentMediaThumbnailView view = new OriginAttachmentMediaThumbnailView(this.context);
                    view.setAttachment(messageId, (File)file, listener);
                    this.addView((View)view, -1, (ViewGroup.LayoutParams)this.getChildLayoutParam());
                    break;
                }
                default: {
                    FileAttachmentView fileView = new FileAttachmentView(this.context);
                    fileView.setAttachment((File)file, listener);
                    this.addView((View)fileView, -1, (ViewGroup.LayoutParams)this.getChildLayoutParam());
                }
            }
        });
    }

    private LinearLayout.LayoutParams getChildLayoutParam() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        int margin = ResUtils.getDimen(this.context, R.dimen.ch_chat_message_attachment_margin) / 2;
        params.setMargins(margin, margin, margin, margin);
        return params;
    }

    @Override
    public void resetView() {
        if (this.getChildCount() > 0) {
            this.clear();
            this.removeAllViews();
        }
    }

    @Override
    public void clear() {
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View view = this.getChildAt(i);
                if (view instanceof MediaThumbnailView) {
                    ((MediaThumbnailView)view).clear();
                }
                if (!(view instanceof FileAttachmentView)) continue;
                ((FileAttachmentView)view).clear();
            }
        }
    }
}

