/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.util.CountryUtils;
import com.zoyi.com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.zoyi.com.google.i18n.phonenumbers.Phonenumber;

public class MobileNumber {
    private int countryCode;
    private String phoneNumber;

    public MobileNumber() {
        this.countryCode = CountryUtils.getDefaultCountryCodeInt();
        this.phoneNumber = "";
    }

    public MobileNumber(@Nullable String mobileNumber) {
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        try {
            if (mobileNumber == null) {
                throw new NullPointerException();
            }
            Phonenumber.PhoneNumber numberProto = phoneUtil.parse((CharSequence)mobileNumber, "");
            this.countryCode = numberProto.getCountryCode();
            this.phoneNumber = phoneUtil.format(numberProto, PhoneNumberUtil.PhoneNumberFormat.NATIONAL).replace("-", "");
        }
        catch (Exception e) {
            this.countryCode = CountryUtils.getDefaultCountryCodeInt();
            this.phoneNumber = "";
        }
    }

    public MobileNumber(int countryCode, String phoneNumber) {
        this.countryCode = countryCode;
        this.phoneNumber = phoneNumber;
    }

    public int getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(int countryCode) {
        this.countryCode = countryCode;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }
}

