/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.action;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.repo.LoungeChatsRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.PluginStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.store.SupportBotStore;
import com.zoyi.channel.plugin.android.store.UserChatStore;

public class LoungeAction {
    public static void fetchLounge(String pluginId, @Nullable String url) {
        LoungeAction.setState(FetchState.LOADING);
        boolean showClosedChats = SettingsStore.get().showClosedChat.get();
        Api.getLoungeData(pluginId, url, showClosedChats).runBy(ActionType.REQUEST_LOUNGE).cancelBy(ActionType.SOCKET_DISCONNECTED, ActionType.SHUTDOWN).run(new RestSubscriber<LoungeChatsRepo>(){

            @Override
            public void onError(RetrofitException error) {
                LoungeAction.setState(FetchState.FAILED);
            }

            @Override
            public void onSuccess(@NonNull LoungeChatsRepo repo) {
                repo.set();
                LoungeAction.setState(FetchState.COMPLETE);
            }
        });
    }

    private static void setState(FetchState fetchState) {
        SupportBotStore.get().supportBotFetchState.set(fetchState);
        UserChatStore.get().userChatsFetchState.set(fetchState);
        ChannelStore.get().channelFetchState.set(fetchState);
        PluginStore.get().pluginFetchState.set(fetchState);
    }
}

