package com.zoyi.channel.plugin.android.view.youtube.player.util;

import androidx.lifecycle.Lifecycle;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;

public class YouTubePlayerUtils {

  /**
   * Calls [YouTubePlayer.cueVideo] or [YouTubePlayer.loadVideo] depending on which one is more appropriate. If it can't decide, calls
   * [YouTubePlayer.cueVideo] by default.
   * <p>
   * In most cases you want to avoid calling [YouTubePlayer.loadVideo] if the Activity/Fragment is not in the foreground. This function
   * automates these checks for you.
   *
   * @param lifecycle    the lifecycle of the Activity or Fragment containing the YouTubePlayerView.
   * @param videoId      id of the video.
   * @param startSeconds the time from which the video should start playing.
   */
  public static void loadOrCueVideo(YouTubePlayer player, Lifecycle lifecycle, @Nullable  String videoId, float startSeconds) {
    loadOrCueVideo(player, lifecycle.getCurrentState() == Lifecycle.State.RESUMED, videoId, startSeconds);
  }


  public static void loadOrCueVideo(YouTubePlayer player, boolean canLoad, @Nullable String videoId, float startSeconds) {
    if (canLoad) {
      player.loadVideo(videoId, startSeconds);
    } else {
      player.cueVideo(videoId, startSeconds);
    }
  }
}
