package com.zoyi.channel.plugin.android.view.viewgroup;

import android.content.Context;
import android.content.res.TypedArray;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;

public class MaxWidthLinearLayout extends LinearLayout {

  private int maxWidth = Integer.MAX_VALUE;

  public MaxWidthLinearLayout(Context context) {
    super(context);

    init(context, null);
  }

  public MaxWidthLinearLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context, attrs);
  }

  public MaxWidthLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context, attrs);
  }

  @Initializer
  private void init(Context context, @Nullable AttributeSet attrs) {
    if (attrs != null) {
      TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaxWidthLinearLayout);

      try {
        maxWidth = typedArray.getDimensionPixelSize(R.styleable.MaxWidthLinearLayout_ch_mwll_maxWidth, maxWidth);
      } finally {
        typedArray.recycle();
      }
    }
  }

  @Override
  protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
    int measuredWidth = MeasureSpec.getSize(widthMeasureSpec);

    if (maxWidth > 0 && maxWidth < measuredWidth) {
      int measureMode = MeasureSpec.getMode(widthMeasureSpec);
      widthMeasureSpec = MeasureSpec.makeMeasureSpec(maxWidth, measureMode);
    }
    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
  }
}
