package com.zoyi.channel.plugin.android.view.option;

import android.content.Context;
import android.content.res.TypedArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.*;

public class CheckView extends FrameLayout {

  private TextView textView;
  private View imageView;

  public CheckView(@NonNull Context context) {
    super(context);

    init(context, null);
  }

  public CheckView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context, attrs);
  }

  public CheckView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context, attrs);
  }

  @Initializer
  private void init(Context context, @Nullable AttributeSet attrs) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_view_check, this, true);

    textView = root.findViewById(R.id.ch_textCheckView);
    imageView = root.findViewById(R.id.ch_imageCheckViewCheck);

    if (attrs != null) {
      TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.CheckView);
      try {
        textView.setText(typedArray.getString(R.styleable.CheckView_ch_cv_text));
      } finally {
        typedArray.recycle();
      }
    }

    setChecked(false);
  }

  public void setChecked(boolean isChecked) {
    textView.setTextColor(ResUtils.getColor(isChecked ? R.color.ch_grey900 : R.color.ch_grey500));
    Views.setVisibility(imageView, isChecked);
  }
}
