package com.zoyi.channel.plugin.android.view.dialog.bottom_sheet;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import androidx.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Utils;

public abstract class BaseBottomSheetDialog extends BottomSheetDialog {

  protected int paddingTop = 0;
  protected int paddingBottom = 0;

  private LinearLayout layoutContent;

  public BaseBottomSheetDialog(@NonNull Context context) {
    super(context);

    setContentView(R.layout.ch_dialog_bottomsheet_base);
    layoutContent = findViewById(R.id.ch_layoutDialogContent);
  }

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    if (getWindow() != null) {
      getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
    }

    if (layoutContent != null) {
      layoutContent.setPadding(
          0,
          (int) Utils.dpToPx(getContext(), paddingTop),
          0,
          (int) Utils.dpToPx(getContext(), paddingBottom)
      );
    }
  }

  protected void addContentView(View view) {
    if (layoutContent != null) {
      layoutContent.addView(view, -1, new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
    }
  }

  protected void setOrientation(int orientation) {
    if (layoutContent != null) {
      layoutContent.setOrientation(orientation);
    }
  }
}
