package com.zoyi.channel.plugin.android.util.message;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;

import com.zoyi.channel.plugin.android.action.MarketingAction;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.enumerate.LinkType;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class LinkSpan extends ClickableSpan {

  private String linkText;
  private LinkType linkType;

  @Nullable
  private Object payload;

  public LinkSpan(String linkText, LinkType linkType, @Nullable Object payload) {
    this.linkText = linkText;
    this.linkType = linkType;
    this.payload = payload;
  }

  @Override
  public void onClick(View view) {
    Executor.executeLinkAction(view.getContext(), linkText, linkType);

    if (payload != null && payload instanceof Marketing) {
      switch (linkType) {
        case URL:
          MarketingAction.sendClickEvent((Marketing) payload, linkText);
          break;

        case EMAIL:
          MarketingAction.sendClickEvent((Marketing) payload, null);
          break;
      }
    }
  }

  @Override
  public void updateDrawState(@NonNull TextPaint textPaint) {
    super.updateDrawState(textPaint);
    try {
      textPaint.setUnderlineText(false);
    } catch (Exception ignored) {
    }
  }
}
