package com.zoyi.channel.plugin.android.store.binder;

import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.store.state.BaseState;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action4;

public class Binder4<E, F, G, H> extends Binder {

  private BaseState<E> state1;
  private BaseState<F> state2;
  private BaseState<G> state3;
  private BaseState<H> state4;

  @Nullable
  private Subscription subscription1;
  @Nullable
  private Subscription subscription2;
  @Nullable
  private Subscription subscription3;
  @Nullable
  private Subscription subscription4;

  public Binder4(BaseState<E> state1, BaseState<F> state2, BaseState<G> state3, BaseState<H> state4) {
    this.state1 = state1;
    this.state2 = state2;
    this.state3 = state3;
    this.state4 = state4;
  }

  public Binder4 bind(Action4<E, F, G, H> action4) {
    this.subscription1 = this.state1.attach(e -> action4.call(e, state2.get(), state3.get(), state4.get()));
    this.subscription2 = this.state2.attach(f -> action4.call(state1.get(), f, state3.get(), state4.get()));
    this.subscription3 = this.state3.attach(g -> action4.call(state1.get(), state2.get(), g, state4.get()));
    this.subscription4 = this.state4.attach(h -> action4.call(state1.get(), state2.get(), state3.get(), h));

    action4.call(state1.get(), state2.get(), state3.get(), state4.get());

    return this;
  }

  @Override
  public void unbind() {
    if (subscription1 != null && !subscription1.isUnsubscribed()) {
      subscription1.unsubscribe();
    }
    if (subscription2 != null && !subscription2.isUnsubscribed()) {
      subscription2.unsubscribe();
    }
    if (subscription3 != null && !subscription3.isUnsubscribed()) {
      subscription3.unsubscribe();
    }
    if (subscription4 != null && !subscription4.isUnsubscribed()) {
      subscription4.unsubscribe();
    }
    subscription1 = null;
    subscription2 = null;
    subscription3 = null;
    subscription4 = null;
  }
}
