package com.zoyi.channel.plugin.android.selector;

import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.store.binder.Binder4;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.rx.functions.Action3;

public class BootDataSelector {

  public static Binder bindBootData(Action3<Plugin, Channel, Integer> action3) {
    State<Plugin> pluginState = PluginStore.get().pluginState;
    State<Channel> channelState = ChannelStore.get().channelState;
    State<Long> nowState = TimerStore.get().now;
    State<Language> languageState = SettingsStore.get().language;

    return new Binder4<>(pluginState, channelState, nowState, languageState).bind((plugin, channel, now, language) -> {
      if (plugin != null && channel != null) {
        action3.call(plugin, channel, ChannelUtils.getMinutesLeftToWork(channel, now));
      }
    });
  }
}
