package com.zoyi.channel.plugin.android.open.model;

import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.com.google.gson.GsonBuilder;

import java.util.HashMap;
import java.util.Map;

public class Profile {

  private HashMap<String, String> primitiveProperties;
  private HashMap<String, Object> properties;

  public static Profile create() {
    return new Profile();
  }

  private Profile() {
    this.primitiveProperties = new HashMap<>();
    this.properties = new HashMap<>();
  }

  public Profile setName(@Nullable String name) {
    this.primitiveProperties.put(Const.PROFILE_NAME_KEY, name);

    return this;
  }

  public Profile setEmail(@Nullable String email) {
    this.primitiveProperties.put(Const.PROFILE_EMAIL_KEY, email);

    return this;
  }

  public Profile setMobileNumber(@Nullable String mobileNumber) {
    this.primitiveProperties.put(Const.PROFILE_MOBILE_NUMBER_KEY, mobileNumber);

    return this;
  }

  public Profile setAvatarUrl(@Nullable String avatarUrl) {
    this.primitiveProperties.put(Const.PROFILE_AVATAR_URL_KEY, avatarUrl);

    return this;
  }

  public Profile setProperty(String propertyKey, @Nullable Object propertyValue) {
    this.properties.put(propertyKey, propertyValue);

    return this;
  }

  public Profile setPrimitiveProperties(HashMap<String, String> primitiveProperties) {
    this.primitiveProperties = primitiveProperties;

    return this;
  }

  private Profile setProperties(HashMap<String, Object> properties) {
    this.properties = properties;

    return this;
  }

  public String toJson() {
    Map<String, Object> profileMap = new HashMap<>();

    for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
      profileMap.put(entry.getKey(), entry.getValue());
    }

    for (Map.Entry<String, String> entry : this.primitiveProperties.entrySet()) {
      profileMap.put(entry.getKey(), entry.getValue());
    }

    return new GsonBuilder().serializeNulls().create().toJson(profileMap);
  }

  @Nullable
  @Deprecated
  public static Profile fromLegacy(@Nullable com.zoyi.channel.plugin.android.Profile profile) {
    if (profile != null) {
      return Profile.create()
          .setPrimitiveProperties(new HashMap<>(profile.getPrimitiveProperties()))
          .setProperties(new HashMap<>(profile.getProperties()));
    }
    return null;
  }
}
