package com.zoyi.channel.plugin.android.network;

import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.annotation.*;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.AppMessengerUri;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.repo.*;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.retrofit2.http.*;
import com.zoyi.rx.Observable;

import java.util.List;

/**
 * Created by mika on 2016. 1. 20..
 */
public interface ChannelApi {

  @Success
  @GET("/packages/{packageId}/versions/latest")
  Observable<PackageRepo> getLastestPackage(@Path("packageId") String packageId, @Query("from") String from);

  @Success
  @GET("/front/user-chats")
  Observable<UserChatsRepo> getUserChats(@Query("sortField") String sortField, @Query("sortOrder") String sortOrder, @Query("limit") Integer limit, @Query("includeClosed") boolean includeClosed);

  @Success
  @GET("/front/user-chats")
  Observable<UserChatsRepo> getUserChatsNext(@Query("sortField") String sortField, @Query("sortOrder") String sortOrder, @Query("limit") Integer limit, @Query("includeClosed") boolean includeClosed, @Query("since") String since);

  @Success
  @GET("/front/user-chats/{userChatId}")
  Observable<UserChatRepo> getUserChat(@Path("userChatId") String userChatId);

  @Success
  @GET("/front/user-chats/{userChatId}/messages")
  Observable<MessagesRepo> getMessages(@Path("userChatId") String userChatId, @Nullable @Query("since") String since, @Query("limit") Integer limit, @Query("sortOrder") String sortOrder);

  @Success
  @FormUrlEncoded
  @POST("/front/plugins/{pluginId}/user-chats")
  Observable<UserChatRepo> createUserChat(@Path("pluginId") String pluginId, @Field("url") String url);

  @Success
  @PUT("/front/user-chats/{userChatId}/messages/read")
  Observable<Void> read(@Path("userChatId") String userChatId);

  @Success
  @Headers({ "Content-Type: application/json" })
  @POST("/front/user-chats/{userChatId}/messages")
  Observable<MessageRepo> sendMessage(@Path("userChatId") String userChatId, @Body RequestBody body);

  @Success
  @Headers({ "Content-Type: application/json" })
  @POST("/front/elastic/push-tokens")
  Observable<EmptyRepo> sendToken(@Body RequestBody body, @Header(Const.X_SESSION) String jwt);

  @Success
  @Headers({ "Content-Type: application/json" })
  @DELETE("/front/elastic/push-tokens/{key}")
  Observable<Void> deleteToken(@Nullable @Header(Const.ACCEPT_LANGUAGE) String acceptLanguage, @Path("key") String key, @Header(Const.X_SESSION) String jwt);

  @Success
  @DELETE("/front/elastic/push-tokens/{key}/of")
  Observable<Void> deleteToken(@Path("key") String key, @Nullable @Query("userId") String userId);

  @Success
  @DELETE("/front/user-chats/{userChatId}")
  Observable<UserChatRepo> removeUserChat(@Path("userChatId") String userChatId);

  @Success
  @PUT("/front/user-chats/{userChatId}/close")
  Observable<MessageRepo> closeUserChat(@Path("userChatId") String userChatId, @Nullable @Query("actionId") String actionId,
                                        @Query("requestId") String requestId);

  @Success
  @FormUrlEncoded
  @PUT("/front/user-chats/{userChatId}/review")
  Observable<MessageRepo> reviewUserChat(@Path("userChatId") String userChatId, @Nullable @Query("actionId") String actionId, @Query("requestId") String requestId, @Field("review") String review);

  @Success
  @GET("/available/countries")
  Observable<List<Country>> getCountries();

  @Success
  @POST("/front/user-chats/{userChatId}/messages/{messageId}/profile-bot")
  Observable<MessageRepo> updateProfileBot(@Path("userChatId") String userChatId, @Path("messageId") String messageId, @Body RequestBody requestBody);

  @Success
  @GET("/front/user-chats/{userChatId}/messages/{messageId}/translate")
  Observable<TranslationRepo> getTranslatedMessage(@Path("userChatId") String userChatId, @Path("messageId") String messageId, @Query("language") String language);

  @Success
  @FormUrlEncoded
  @POST("/front/support-bots/{supportBotId}/user-chats")
  Observable<UserChatRepo> createSupportBotUserChat(@Path("supportBotId") String supportBotId, @Field("url") String url);

  @Pass
  @POST("/front/user-chats/{userChatId}/support-bot/buttons/{buttonId}")
  Observable<MessageRepo> submitButtonAction(@Path("userChatId") String userChatId, @Nullable @Path("buttonId") String buttonId, @Nullable @Query("actionId") String messageId, @Nullable @Query("requestId") String requestId);

  @Pass
  @PUT("/front/user-chats/{userChatId}/messages/receive")
  Observable<Void> receivePushNotification(@Path("userChatId") String userChatId, @Header(Const.X_SESSION) String jwt);

  @Failed("https://github.com/zoyi/ch-dropwizard/issues/1715")
  @GET("/front/plugins/{pluginId}/profile-bot-schemas")
  Observable<ProfileBotSchemasRepo> getProfileBotSchemas(@Path("pluginId") String pluginId);

  @Success
  @PATCH("/front/users/me")
  Observable<UserRepo> updateUser(@Body RequestBody body);

  @Success
  @DELETE("/front/users/me/pop-up")
  Observable<Void> closePopUp();

  @Success
  @FormUrlEncoded
  @POST("/front/plugins/{pluginId}/lounge")
  Observable<LoungeRepo> getLounge(@Path("pluginId") String pluginId, @Nullable @Field("url") String url);

  @Success
  @GET("/front/app/{appMessengerName}/connect")
  Observable<AppMessengerUri> getMessengerConnect(@Path("appMessengerName") String appMessengerName);

  @Success
  @POST("/front/user-chats/{userChatId}/support-bots/{supportBotId}")
  Observable<MessageRepo> createMarketingSupportBotUserChat(@Path("userChatId") String userChatId, @Nullable @Path("supportBotId") String supportBotId);

  @GET("/front/campaigns/{campaignId}/users/{userId}/click")
  Observable<Void> campaignClick(@Path("campaignId") String campaignId, @Path("userId") String userId, @Nullable @Query("url") String url);

  @PUT("/front/campaigns/{campaignId}/view")
  Observable<Void> campaignView(@Path("campaignId") String campaignId);

  @GET("/front/one-time-msgs/{oneTimeMsgId}/users/{userId}/click")
  Observable<Void> oneTimeMsgClick(@Path("oneTimeMsgId") String oneTimeMsgId, @Path("userId") String userId, @Nullable @Query("url") String url);

  @PUT("/front/one-time-msgs/{oneTimeMsgId}/view")
  Observable<Void> oneTimeMsgView(@Path("oneTimeMsgId") String oneTimeMsgId);

  @PATCH("/front/users/me/tags")
  Observable<UserRepo> addTags(@Nullable @Query("tags") List<String> tags);

  @DELETE("/front/users/me/tags")
  Observable<UserRepo> removeTags(@Nullable @Query("tags") List<String> tags);

  @GET("/front/campaigns/{campaignId}/support-bot")
  Observable<SupportBotRepo> getCampaignSupportBot(@Nullable @Path("campaignId") String campaignId);

  @GET("/front/one-time-msgs/{oneTimeMsgId}/support-bot")
  Observable<SupportBotRepo> getOneTimeMessageSupportBot(@Nullable @Path("oneTimeMsgId") String oneTimeMsgId);

  @DELETE("/front/user-chats/{userChatId}/messages/{messageId}")
  Observable<MessageRepo> deleteMessage(@Path("userChatId") String userChatId, @Path("messageId") String messageId);

  @GET("/front/managers")
  Observable<ManagersRepo> getManagers(@Nullable @Query("managerIds") List<String> managerIds);
}
