package com.zoyi.channel.plugin.android.model.rest;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.entity.Entity;

/**
 * Created by mika on 2016. 12. 6..
 */
public class Plugin implements Entity {

  private String id;
  @Nullable
  private String key;
  @Nullable
  private String color;
  @Nullable
  private I18n welcomeI18n;
  @Nullable
  private String textColor;
  @Nullable
  private String gradientColor;
  @Nullable
  private Boolean showPoweredBy;

  @Override
  public String getId() {
    return id;
  }

  @Nullable
  public String getKey() {
    return key;
  }

  @ColorInt
  public int getBackgroundColor() {
    try {
      return Color.parseColor(color);
    } catch (Exception ex) {
    }
    return Color.BLACK;
  }

  @ColorInt
  public int getTextColor() {
    return "black".equals(textColor) ? Color.BLACK : Color.WHITE;
  }

  public int getGradientColor() {
    try {
      return Color.parseColor(gradientColor);
    } catch (Exception ex) {
    }
    return Color.BLACK;
  }

  @Nullable
  public I18n getWelcomeI18n() {
    return welcomeI18n;
  }

  public boolean isShowPoweredBy() {
    if (showPoweredBy == null) {
      return false;
    }
    return showPoweredBy;
  }
}
