package com.zoyi.channel.plugin.android.model.rest;

import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;

public class Marketing {

  private String id;
  @Nullable
  private String type;
  @Nullable
  private Boolean advertising;

  @Nullable
  private String exposureType;

  @Nullable
  private Boolean enableSupportBot;

  public String getId() {
    return id;
  }

  @Nullable
  public String getType() {
    return type;
  }

  public boolean isAdvertising() {
    if (advertising != null) {
      return advertising;
    }
    return false;
  }

  @Nullable
  public String getExposureType() {
    return exposureType;
  }

  public boolean isFullScreen() {
    return Const.EXPOSURE_TYPE_FULL_SCREEN.equals(exposureType);
  }

  // TODO : change function name to isEnableSupportBot
  public boolean getEnableSupportBot() {
    if (enableSupportBot == null) {
      return false;
    }
    return enableSupportBot;
  }
}
