package com.zoyi.channel.plugin.android.model.rest;

import androidx.annotation.Nullable;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.OnIntegrationClickListener;
import com.zoyi.channel.plugin.android.model.entity.Contact;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class AppMessenger implements Contact {

  private String iconKey;
  private String name;

  public String getIconKey() {
    return iconKey;
  }

  @Nullable
  @Override
  public String getTitle() {
    return null;
  }

  @Nullable
  @Override
  public String getDescription() {
    return null;
  }

  @Override
  public void setIcon(ImageView imageView) {
    Glide.with(imageView.getContext())
        .load(UriUtils.getCloudFrontUrl() + "/" + iconKey)
        .dontAnimate()
        .diskCacheStrategy(DiskCacheStrategy.RESULT)
        .into(imageView);
  }

  @Override
  public void doAction(@Nullable OnIntegrationClickListener listener) {
    if (listener != null) {
      listener.onMessengerClick(name);
    }
  }
}
