package com.zoyi.channel.plugin.android.bind;

import androidx.annotation.Nullable;

public interface BinderController extends BinderControllerInterface {

  BinderCollection getBinderCollection();

  @Override
  default boolean isRunning(BindAction action) {
    return getBinderCollection().isRunning(action);
  }

  @Override
  default void bind(@Nullable Binder binder) {
    if (binder != null) {
      getBinderCollection().bind(binder);
    }
  }

  @Override
  default void bind(@Nullable Binder binder, BindAction action) {
    if (binder != null) {
      getBinderCollection().bind(binder, action);
    }
  }

  @Override
  default void unbind(BindAction action) {
    getBinderCollection().unbind(action);
  }

  @Override
  default void clear() {
    getBinderCollection().clear();
  }

  @Override
  default void unbindAll() {
    getBinderCollection().unbindAll();
  }
}
