package com.zoyi.channel.plugin.android.activity.photo_album;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.FileMeta;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoView;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

import java.util.ArrayList;
import java.util.List;

public class PhotoAlbumPagerAdapter extends PagerAdapter {

  private Context context;
  private PhotoViewAttacher.OnPhotoTapListener listener;
  private LayoutInflater inflater;
  @NonNull
  private List<FileMeta> fileMetas = new ArrayList<>();

  public PhotoAlbumPagerAdapter(Context context, PhotoViewAttacher.OnPhotoTapListener listener) {
    inflater = LayoutInflater.from(context);

    this.context = context;
    this.listener = listener;
  }

  public void setItems(@NonNull List<FileMeta> fileMetas) {
    this.fileMetas.addAll(fileMetas);
  }

  @Nullable
  public FileMeta getItem(int position) {
    if (position >= 0 && position < fileMetas.size()) {
      return fileMetas.get(position);
    }
    return null;
  }

  @Override
  public int getCount() {
    return fileMetas.size();
  }

  @Override
  public int getItemPosition(Object item) {
    return POSITION_NONE;
  }

  @Override
  public boolean isViewFromObject(View view, Object object) {
    return view.equals(object);
  }

  @Override
  public void destroyItem(ViewGroup container, int position, Object object) {
    if (container != null && object != null && object instanceof View) {
      container.removeView((View) object);
    }
  }

  @Override
  public Object instantiateItem(ViewGroup container, int position) {
    FileMeta fileMeta = fileMetas.get(position);
    View view = inflater.inflate(R.layout.ch_plugin_item_photo_album, container, false);
    PhotoView photoView = view.findViewById(R.id.ch_imagePhotoAlbumPhotoView);
    photoView.setOnPhotoTapListener(listener);

    Glide.with(context)
        .load(fileMeta.getUrl())
        .diskCacheStrategy(DiskCacheStrategy.SOURCE)
        .dontAnimate()
        .into(photoView);

    container.addView(view);

    return view;
  }
}
