package com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.widget.ImageView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.OnIntegrationClickListener;
import com.zoyi.channel.plugin.android.model.entity.Contact;

public class LinkContact implements Contact {

  @NonNull
  private final String link;

  public LinkContact(@NonNull String link) {
    this.link = link;
  }

  @Nullable
  @Override
  public String getTitle() {
    return "상담 링크복사???";
  }

  @Nullable
  @Override
  public String getDescription() {
    return link;
  }

  @Override
  public void setIcon(ImageView imageView) {
    imageView.setImageResource(R.drawable.ch_plugin_integration_link);
  }

  @Override
  public void doAction(@Nullable OnIntegrationClickListener listener) {
    if (listener != null) {
      listener.onLinkClick(link);
    }
  }
}
