package com.zoyi.channel.plugin.android.activity.chat.view.reactions;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import com.google.android.material.tabs.TabLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.dialog.OnReactionsTabChangeListener;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;

import java.util.List;

public class ReactionsTabLayout extends FrameLayout {

  public ReactionsTabLayout(@NonNull Context context) {
    super(context);

    init(context);
  }

  public ReactionsTabLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  private Context context;
  private TabLayout tabReactions;

  @Nullable
  private OnReactionsTabChangeListener listener;

  @Initializer
  private void init(Context context) {
    LayoutInflater.from(context).inflate(R.layout.ch_view_reactions_tab_layout, this);

    this.context = context;

    tabReactions = findViewById(R.id.ch_tabReactions);

    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP && !tabReactions.getClipToPadding()) {
      if (tabReactions.getChildAt(0) instanceof ViewGroup) {
        ViewGroup realTabLayout = (ViewGroup) tabReactions.getChildAt(0);
        realTabLayout.setClipToPadding(false);
        realTabLayout.setPadding((int) Utils.dpToPx(context, 12), 0, (int) Utils.dpToPx(context, 12), 0);
      }
    }

    tabReactions.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
      @Override
      public void onTabSelected(TabLayout.Tab tab) {
        setBold(tab, true);

        if (listener != null) {
          listener.onTabChanged(tab.getPosition());
        }
      }

      @Override
      public void onTabUnselected(TabLayout.Tab tab) {
        setBold(tab, false);
      }

      @Override
      public void onTabReselected(TabLayout.Tab tab) {
        setBold(tab, true);
      }
    });
  }

  public void setTabs(List<Pair<String, Integer>> reactionData) {
    for (Pair<String, Integer> data : reactionData) {
      ReactionsTabView tabView = new ReactionsTabView(context);
      tabView.bind(data.first, data.second);

      tabReactions.addTab(tabReactions.newTab().setCustomView(tabView));
    }
  }

  private void setBold(TabLayout.Tab tab, boolean bold) {
    if (tab.getCustomView() instanceof ReactionsTabView) {
      ((ReactionsTabView) tab.getCustomView()).setBold(bold);
    }
  }

  public void setListener(@Nullable OnReactionsTabChangeListener listener) {
    this.listener = listener;
  }
}
