package com.zoyi.channel.plugin.android.activity.chat.view.profilebot;

import android.content.Context;
import android.graphics.Color;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.util.*;

public class ProfileBotInputBooleanView extends BaseProfileBotInputView {

  public ProfileBotInputBooleanView(@NonNull Context context) {
    super(context);
  }

  public ProfileBotInputBooleanView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public ProfileBotInputBooleanView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  private View layoutYes;
  private TextView buttonYes;
  private View progressYes;

  private View layoutNo;
  private TextView buttonNo;
  private View progressNo;

  @Initializer
  @Override
  public void initView(View root) {
    layoutYes = root.findViewById(R.id.ch_layoutProfileBotInputBooleanYes);
    buttonYes = root.findViewById(R.id.ch_buttonProfileBotInputBooleanYes);
    progressYes = root.findViewById(R.id.ch_progressProfileBotInputBooleanYes);

    layoutNo = root.findViewById(R.id.ch_layoutProfileBotInputBooleanNo);
    buttonNo = root.findViewById(R.id.ch_buttonProfileBotInputBooleanNo);
    progressNo = root.findViewById(R.id.ch_progressProfileBotInputBooleanNo);

    buttonYes.setOnClickListener(v -> submit(true));
    buttonNo.setOnClickListener(v -> submit(false));
  }

  @Nullable
  @Override
  public Object getValue() {
    // send information directly so not used
    return null;
  }

  @Override
  protected void restore(@Nullable Object value, FetchState fetchState) {
    if (fetchState == FetchState.LOADING && value instanceof Boolean) {
      boolean boolValue = (boolean) value;

      if (boolValue) {
        setLoading(layoutYes, buttonYes, progressYes);
        setIdle(layoutNo, buttonNo, progressNo);
      } else {
        setIdle(layoutYes, buttonYes, progressYes);
        setLoading(layoutNo, buttonNo, progressNo);
      }
    } else {
      setIdle(layoutYes, buttonYes, progressYes);
      setIdle(layoutNo, buttonNo, progressNo);
    }
  }

  private void setLoading(View layout, TextView button, View progress) {
    layout.setBackgroundColor(ResUtils.getColor(R.color.ch_grey300));

    Views.setVisibility(button, false);
    Views.setVisibility(progress, true);
  }

  private void setIdle(View layout, TextView button, View progress) {
    layout.setBackgroundColor(Color.WHITE);

    Views.setVisibility(button, true);
    Views.setVisibility(progress, false);
  }

  @Override
  public void focus() {
    // do nothing
  }

  @Override
  public int getLayoutId() {
    return R.layout.ch_view_profile_bot_input_boolean;
  }
}
