package com.zoyi.channel.plugin.android.activity.chat.view.chat;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.view.OnNewMessageAlertClickListener;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

/**
 * Created by mika on 2018. 10. 23..
 */

public class NewMessageAlertView extends FrameLayout {

  private View root;
  private AvatarLayout avatarPreview;

  @Nullable
  private OnNewMessageAlertClickListener listener;

  public NewMessageAlertView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public NewMessageAlertView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public NewMessageAlertView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(Context context) {
    root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_new_message_alert, this);

    root.setOnClickListener(new OnClickListener() {
      @Override
      public void onClick(View v) {
        hide();

        if (listener != null) {
          listener.onNewMessageAlertClick();
        }
      }
    });

    avatarPreview = (AvatarLayout) root.findViewById(R.id.ch_layoutAvatarPreview);
  }

  public void setListener(OnNewMessageAlertClickListener listener) {
    this.listener = listener;
  }

  public void show(@Nullable ProfileEntity profileEntity) {
    avatarPreview.set(profileEntity);
    root.setVisibility(View.VISIBLE);
  }

  public void hide() {
    root.setVisibility(View.GONE);
  }
}
